/**********************************************************************
** $Id: qprinter.i,v 1.1.1.1 2002/12/22 14:20:11 taka-hr Exp $
**
** Definition of QPrinter class
**
** Created : 940927
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QPRINTER_H
//#define QPRINTER_H

//#ifndef QT_H
//#include "qpaintdevice.h"
//#include "qstring.h"
//#endif // QT_H

//#if defined(B0)
//#undef B0 // Terminal hang-up.  We assume that you do not want that.
//#endif

class QPrinter : public QPaintDevice
{
public:
    QPrinter();
   ~QPrinter();

    enum Orientation { Portrait, Landscape };

    enum PageSize    { A4, B5, Letter, Legal, Executive,
		       A0, A1, A2, A3, A5, A6, A7, A8, A9, B0, B1,
		       B10, B2, B3, B4, B6, B7, B8, B9, C5E, Comm10E,
		       DLE, Folio, Ledger, Tabloid, NPageSize };

    enum PageOrder   { FirstPageFirst, LastPageFirst };

    enum ColorMode   { GrayScale, Color };

    QString printerName() const;
    virtual void setPrinterName( const QString &);
    bool outputToFile()	const;
    virtual void setOutputToFile( bool );
    QString outputFileName()const;
    virtual void setOutputFileName( const QString &);

    QString printProgram() const;
    virtual void setPrintProgram( const QString &);

    QString printerSelectionOption() const;
    virtual void setPrinterSelectionOption( const QString & );

    QString docName() const;
    virtual void setDocName( const QString &);
    QString creator() const;
    virtual void setCreator( const QString &);

    Orientation orientation()	const;
    virtual void setOrientation( Orientation );
    PageSize	pageSize()	const;
    virtual void setPageSize( PageSize );

    virtual void setPageOrder( PageOrder );
    PageOrder	pageOrder() const;

    virtual void setColorMode( ColorMode );
    ColorMode	colorMode() const;

    virtual void	setFullPage( bool );
    bool		fullPage() const;
    QSize	margins()	const;

    int		fromPage()	const;
    int		toPage()	const;
    virtual void setFromTo( int fromPage, int toPage );
    int		minPage()	const;
    int		maxPage()	const;
    virtual void setMinMax( int minPage, int maxPage );
    int		numCopies()	const;
    virtual void setNumCopies( int );

    bool	newPage();
    bool	abort();
    bool	aborted()	const;

    bool	setup( QWidget *parent = 0 );
/*
protected:
    bool	cmd( int, QPainter *, QPDevCmdParam * );
    int		metric( int ) const;

#if defined(_WS_WIN_)
    virtual void	setActive();
    virtual void	setIdle();
#endif

private:
#if defined(_WS_X11_)
    QPaintDevice *pdrv;
    int		pid;
#endif
    int		state;
    QString	printer_name;
    QString	option_string;
    QString	output_filename;
    bool	output_file;
    QString	print_prog;
    QString	doc_name;
    QString	creator_name;
    Orientation orient;
    PageSize	page_size;
    bool	to_edge;
    short	from_pg, to_pg;
    short	min_pg,	 max_pg;
    short	ncopies;
#if defined(_WS_WIN_)
    bool	viewOffsetDone;
    QPainter*   painter;
    void	readPdlg( void* );
    void	readPdlgA( void* );
#endif

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
    QPrinter( const QPrinter & );
    QPrinter &operator=( const QPrinter & );
#endif
*/
};

//#endif // QPRINTER_H
