/****************************************************************************
** $Id: qpalette.i,v 1.1.1.1 2002/12/22 14:20:10 taka-hr Exp $
**
** Definition of QColorGroup and QPalette classes
**
** Created : 950323
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QPALETTE_H
//#define QPALETTE_H

//#ifndef QT_H
//#include "qwindowdefs.h"
//#include "qcolor.h"
//#include "qshared.h"
//#include "qbrush.h"
//#endif // QT_H


class QColorGroupPrivate;


class  QColorGroup
{
public:
%extend {
	 QColorGroup(VALUE varg0=Qnil, VALUE varg1=Qnil, VALUE varg2=Qnil,
							 VALUE varg3=Qnil, VALUE varg4=Qnil, VALUE varg5=Qnil,
							 VALUE varg6=Qnil, VALUE varg7=Qnil, VALUE varg8=Qnil) {
			if(varg0 == Qnil) {
				 return new QColorGroup();
			} else if(varg7 == Qnil)  {
				 QColor* arg0;
				 QColor* arg1;
				 QColor* arg2;
				 QColor* arg3;
				 QColor* arg4;
				 QColor* arg5;
				 QColor* arg6;
				 arg0 = (QColor *)Get_QColor(varg0);
				 arg1 = (QColor *)Get_QColor(varg1);
				 arg2 = (QColor *)Get_QColor(varg2);
				 arg3 = (QColor *)Get_QColor(varg3);
				 arg4 = (QColor *)Get_QColor(varg4);
				 arg5 = (QColor *)Get_QColor(varg5);
				 arg6 = (QColor *)Get_QColor(varg6);
				 return new QColorGroup(*arg0,*arg1,*arg2,*arg3,*arg4,*arg5,*arg6);
			} else if(rb_obj_is_kind_of(varg0,cQBrush) &&
							rb_obj_is_kind_of(varg1,cQBrush) &&  
							rb_obj_is_kind_of(varg2,cQBrush) &&  
							rb_obj_is_kind_of(varg3,cQBrush) &&  
							rb_obj_is_kind_of(varg4,cQBrush) &&  
							rb_obj_is_kind_of(varg5,cQBrush) &&  
							rb_obj_is_kind_of(varg6,cQBrush) &&  
							rb_obj_is_kind_of(varg7,cQBrush) &&
							rb_obj_is_kind_of(varg8,cQBrush)) {
				 QBrush* arg0; 
				 QBrush* arg1; 
				 QBrush* arg2; 
				 QBrush* arg3; 
				 QBrush* arg4; 
				 QBrush* arg5; 
				 QBrush* arg6; 
				 QBrush* arg7;
				 QBrush* arg8; 
				 arg0 = (QBrush *)Get_QBrush(varg0);
				 arg1 = (QBrush *)Get_QBrush(varg1);
				 arg2 = (QBrush *)Get_QBrush(varg2);
				 arg3 = (QBrush *)Get_QBrush(varg3);
				 arg4 = (QBrush *)Get_QBrush(varg4);
				 arg5 = (QBrush *)Get_QBrush(varg5);
				 arg6 = (QBrush *)Get_QBrush(varg6);
				 arg7 = (QBrush *)Get_QBrush(varg7);
				 arg8 = (QBrush *)Get_QBrush(varg8);
				 return new QColorGroup(*arg0,*arg1,*arg2,*arg3,*arg4,*arg5,*arg6,*arg7,*arg8);
			} else {
				 rb_raise(rb_eArgError,"Error in QColorGroup constructor");
			}
	 }
}
				 
			 
				 
//    QColorGroup();
//    QColorGroup( const QColor &foreground, const QColor &button,
//		 const QColor &light, const QColor &dark, const QColor &mid,
//		 const QColor &text, const QColor &base );
//    QColorGroup( const QBrush &foreground, const QBrush &button,
//		 const QBrush &light, const QBrush &dark, const QBrush &mid,
//		 const QBrush &text, const QBrush &bright_text,
//		 const QBrush &base, const QBrush &background);
//    QColorGroup( const QColorGroup & );

	 ~QColorGroup();

//    QColorGroup& operator =(const QColorGroup&);

		// Do not change the order, the serialization format depends on it
		enum ColorRole { Foreground, Button, Light, Midlight, Dark, Mid,
										 Text, BrightText, ButtonText, Base, Background, Shadow,
										 Highlight, HighlightedText,
		     NColorRoles };

		const QColor &color( ColorRole ) const;
		const QBrush &brush( ColorRole ) const;
		void setColor( ColorRole, const QColor & );
		void setBrush( ColorRole, const QBrush & );

		const QColor &foreground()	const	{ return br[Foreground].color(); }
		const QColor &button()	const	{ return br[Button].color(); }
		const QColor &light()	const	{ return br[Light].color(); }
		const QColor &dark()	const	{ return br[Dark].color(); }
		const QColor &mid()		const	{ return br[Mid].color(); }
		const QColor &text()	const	{ return br[Text].color(); }
		const QColor &base()	const	{ return br[Base].color(); }
		const QColor &background()	const	{ return br[Background].color(); }

		const QColor &midlight()	const	{ return br[Midlight].color(); }
		const QColor &brightText()	const	{ return br[BrightText].color(); }
		const QColor &buttonText()	const	{ return br[ButtonText].color(); }
		const QColor &shadow()	const	{ return br[Shadow].color(); }
		const QColor &highlight()	const	{ return br[Highlight].color(); }
		const QColor &highlightedText() const{return br[HighlightedText].color(); }

//    bool	operator==( const QColorGroup &g ) const;
//    bool	operator!=( const QColorGroup &g ) const
//	{ return !(operator==(g)); }
/*
private:
		QBrush *br;
		QColorGroupPrivate * d;

		friend class QPalette;
*/
};


class QPalette
{
public:
%extend {
	 QPalette(VALUE varg0=Qnil, VALUE varg1=Qnil, VALUE varg2=Qnil) {
			if(varg0 == Qnil) {
				 return new QPalette();
			} else if(rb_obj_is_kind_of(varg0,cQColor) &&
							 varg1 == Qnil) {
				 QColor* arg0;
				 arg0 = (QColor *)Get_QColor(varg0);
				 return new QPalette(*arg0);
			} else if(rb_obj_is_kind_of(varg0,cQColorGroup) &&
				 rb_obj_is_kind_of(varg1,cQColorGroup) &&
				 rb_obj_is_kind_of(varg2,cQColorGroup)) {
				QColorGroup *arg0;
				QColorGroup *arg1;
				QColorGroup *arg2;
				arg0 = (QColorGroup *)Get_QColorGroup(varg0);
				arg1 = (QColorGroup *)Get_QColorGroup(varg1);
				arg2 = (QColorGroup *)Get_QColorGroup(varg2);
				 return new QPalette(*arg0,*arg1,*arg2);
			} else {
				 rb_raise(rb_eArgError,"Error in QColorGroup constructor");
			}
	 }
}
				
//    QPalette();
//    QPalette( const QColor &button );
//    QPalette( const QColor &button, const QColor &background );
//    QPalette( const QColorGroup &active, const QColorGroup &disabled,
//	      const QColorGroup &inactive );
//    QPalette( const QPalette & );
	 ~QPalette();
//    QPalette &operator=( const QPalette & );

		enum ColorGroup { Normal, Disabled, Active, Inactive, NColorGroups };

		const QColor &color( ColorGroup, QColorGroup::ColorRole ) const;
		const QBrush &brush( ColorGroup, QColorGroup::ColorRole ) const;
//    void setColor( ColorGroup, QColorGroup::ColorRole, const QColor & );
//    void setBrush( ColorGroup, QColorGroup::ColorRole, const QBrush & );

		//RENAME %name(setColorColorRole) void setColor( QColorGroup::ColorRole, const QColor & );
		//RENAME %name(setBrushColorRole) void setBrush( QColorGroup::ColorRole, const QBrush & );

		%extend {
			 void setColor(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
					QColorGroup::ColorRole crole;
					QColor* qcol;
					if(rb_obj_is_kind_of(varg1,cQColor)) {
						 crole = (QColorGroup::ColorRole)NUM2INT(varg0);
						 qcol = (QColor *)Get_QColor(varg1);
						 self->setColor(crole,*qcol);
					} else {
						 QPalette::ColorGroup cg;
						 cg = (QPalette::ColorGroup)NUM2INT(varg0);
						 crole = (QColorGroup::ColorRole)NUM2INT(varg1);
						 qcol = (QColor *)Get_QColor(varg2);
						 self->setColor(cg,crole,*qcol);
					}
			 }
			void setBrush(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
					QColorGroup::ColorRole crole;
					QBrush* qbrush;
					if(rb_obj_is_kind_of(varg1,cQBrush)) {
						 crole = (QColorGroup::ColorRole)NUM2INT(varg0);
						 qbrush = (QBrush *)Get_QBrush(varg1);
						 self->setBrush(crole,*qbrush);
					} else {
						 QPalette::ColorGroup cg;
						 cg = (QPalette::ColorGroup)NUM2INT(varg0);
						 crole = (QColorGroup::ColorRole)NUM2INT(varg1);
						 qbrush = (QBrush *)Get_QBrush(varg2);
						 self->setBrush(cg,crole,*qbrush);
					}
			 }
		}         
						 

		QPalette	copy() const;

		const QColorGroup &active() const { return data->active; }
		const QColorGroup &disabled() const { return data->disabled; }
		const QColorGroup &inactive() const { return data->inactive; }
		const QColorGroup &normal() const { return data->normal; } // obsolete

		void	setActive( const QColorGroup & );
		void	setDisabled( const QColorGroup & );
		void	setInactive( const QColorGroup & );
		void	setNormal( const QColorGroup & ); // obsolete

//    bool	operator==( const QPalette &p ) const;
//    bool	operator!=( const QPalette &p ) const
//					{ return !(operator==(p)); }
		bool	isCopyOf( const QPalette & );

		int		serialNumber() const	{ return data->ser_no; }
/*
private:
		void	detach();
		QBrush 	&directBrush( ColorGroup, QColorGroup::ColorRole ) const;

		struct QPalData : public QShared {
	QColorGroup normal; // ##### alias for active due to inline functions above, remove 3.0
	QColorGroup disabled;
	QColorGroup active;
	int	    ser_no;
	QColorGroup inactive;
		} *data;
*/
};


//#endif // QPALETTE_H
