/****************************************************************************
** $Id: qobject.i,v 1.1.1.1 2002/12/22 14:20:09 taka-hr Exp $
**
** Definition of QObject class
**
** Created : 930418
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QOBJECT_H
//#define QOBJECT_H

//#ifndef QT_H
//#include "qobjectdefs.h"
//#include "qwindowdefs.h"
//#include "qstring.h"
//#include "qevent.h"
//#include "qnamespace.h"
//#include "qstringlist.h" // obsolete
//#endif // QT_H

//#define QT_TR_NOOP(x) (x)
//#define QT_TRANSLATE_NOOP(scope,x) (x)

class QMetaObject;
class QVariant;

class QObject: public Qt
{
/*
		Q_PROPERTY( QCString name READ name WRITE setName )
*/
public:
		QObject( QObject *parent=0, const char *name=0 );
//    virtual ~QObject();
		%extend {
		// For identification of subclass instance in ruby
		void setQObjectName(const char *name)
		{
			 self->QObject::setName(name);
		}
		}
		static QString tr(const char*);

		virtual bool event( QEvent * );
		virtual bool eventFilter( QObject *, QEvent * );

		virtual QMetaObject *metaObject() const { return staticMetaObject(); }
		virtual const char	*className()  const;

		bool	 isA( const char * )	 const;
		bool	 inherits( const char * ) const;

		//const char  *name() const;
		//RENAME %name(nameDefName) const char  *name( const char * defaultName ) const;
		%extend {
			 const char *name(const char* defaultName=0) {
					if(defaultName == 0) {
						 return self->name();
				 } else {
						 return self->name(defaultName);
				 }
			}
	 }   
		virtual void setName( const char *name );
		bool	 isWidgetType()	  const { return isWidget; }
		bool	 highPriority()	  const { return FALSE; }

		bool	 signalsBlocked()  const { return blockSig; }
		void	 blockSignals( bool b );

		int		 startTimer( int interval );
		void	 killTimer( int id );
		void	 killTimers();

		QObject           *child( const char *name, const char *type = 0 );
		const QObjectList *children() const { return childObjects; }

		static const QObjectList *objectTrees();
		
		QObjectList	      *queryList( const char *inheritsClass = 0,
				  const char *objName = 0,
				  bool regexpMatch = TRUE,
				  bool recursiveSearch = TRUE ); //### const in 3.0

		virtual void insertChild( QObject * );
		virtual void removeChild( QObject * );

		void	 installEventFilter( const QObject * );
		void	 removeEventFilter( const QObject * );

		static bool  connect( const QObject *sender, const char *signal,
			  const QObject *receiver, const char *member );
//    bool	 connect( const QObject *sender, const char *signal,
//			  const char *member ) const;
		static bool  disconnect( const QObject *sender, const char *signal,
			     const QObject *receiver, const char *member );
		%name(disconnectSignal) bool	 disconnect( const char *signal=0,
			     const QObject *receiver=0, const char *member=0 );
		%name(disconnectReceiver) bool	 disconnect( const QObject *receiver, const char *member=0 );
			
		void	 dumpObjectTree();
		void	 dumpObjectInfo();
#ifndef QT_NO_PROPERTIES
		//bool setProperty( const char *name, const QVariant& value ); // virtual in Qt 3.0
		%extend{
			bool setProperty(VALUE name, VALUE value) {
				 const char* cname;
				 QVariant * cvalue;
				 if(TYPE(name) == T_STRING) {
						cname = STR2CSTR(name);
						if(rb_obj_is_kind_of(value,cQVariant)) {
							 QVariant *qtmp;
							 qtmp = (QVariant *)Get_QVariant(value);
							 return self->setProperty(cname,*qtmp);
					 }  else if(TYPE(value) == T_STRING || rb_obj_is_kind_of(value,cQString)) {
							 QString *qstr;
							 qstr = (QString *)Get_QString(value);
							 return self->setProperty(cname,*qstr);
					 }  else if(rb_obj_is_kind_of(value,cQStringList)) {
							 QStringList *qtmp;
							 qtmp = (QStringList *)Get_QStringList(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQFont)) {
							 QFont *qtmp;
							 qtmp = (QFont *)Get_QFont(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQPixmap)) {
							 QPixmap *qtmp;
							 qtmp = (QPixmap *)Get_QPixmap(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQImage)) {
							 QImage *qtmp;
							 qtmp = (QImage *)Get_QImage(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQBrush)) {
							 QBrush *qtmp;
							 qtmp = (QBrush *)Get_QBrush(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQPoint)) {
							 QPoint *qtmp;
							 qtmp = (QPoint *)Get_QPoint(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQRect)) {
							 QRect *qtmp;
							 qtmp = (QRect *)Get_QRect(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQRect)) {
							 QRect *qtmp;
							 qtmp = (QRect *)Get_QRect(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQSize)) {
							 QSize *qtmp;
							 qtmp = (QSize *)Get_QSize(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQColor)) {
							 QColor *qtmp;
							 qtmp = (QColor *)Get_QColor(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQPalette)) {
							 QPalette *qtmp;
							 qtmp = (QPalette *)Get_QPalette(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQColorGroup)) {
							 QColorGroup *qtmp;
							 qtmp = (QColorGroup *)Get_QColorGroup(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQIconSet)) {
							 QIconSet *qtmp;
							 qtmp = (QIconSet *)Get_QIconSet(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQPointArray)) {
							 QPointArray *qtmp;
							 qtmp = (QPointArray *)Get_QPointArray(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQRegion)) {
							 QRegion *qtmp;
							 qtmp = (QRegion *)Get_QRegion(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQBitmap)) {
							 QBitmap *qtmp;
							 qtmp = (QBitmap *)Get_QBitmap(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQCursor)) {
							 QCursor *qtmp;
							 qtmp = (QCursor *)Get_QCursor(value);
							 return self->setProperty(cname,*qtmp);
					 } else if (rb_obj_is_kind_of(value,cQSizePolicy)) {
							 QSizePolicy *qtmp;
							 qtmp = (QSizePolicy *)Get_QSizePolicy(value);
							 return self->setProperty(cname,*qtmp);             
					 } else if (TYPE(value) == T_FIXNUM) {
							 int cint;
							 cint = NUM2INT(value);
							 return self->setProperty(cname,cint);
					 } else if (TYPE(value) == T_FLOAT) {
							 double cdbl;
							 cdbl = NUM2DBL(value);
							 return self->setProperty(cname,cdbl);
					 } else if (value == Qtrue || value == Qfalse) {
							bool cbool=TRUE;
							if(value == Qfalse) 
								 cbool = FALSE;
							 return self->setProperty(cname,cbool);
					 } else {
							rb_raise(rb_eTypeError, "Error in value of setProperty()");
					 }
				} else {
					 rb_raise(rb_eTypeError, "Error in name of setProperty():String expected");   
				}        
		 }
	}
															

		QVariant property( const char *name ) const;    // virtual in Qt 3.0
#endif

//signals:
//    void	 destroyed();

public:
		QObject	*parent() const { return parentObj; }

private: // slots:
		void	 cleanupEventFilter();

protected:
		bool	 activate_filters( QEvent * );
		QConnectionList *receivers( const char *signal ) const;
		void	 activate_signal( const char *signal );
		void	 activate_signal( const char *signal, short );
		void	 activate_signal( const char *signal, int );
		void	 activate_signal( const char *signal, long );
		void	 activate_signal( const char *signal, const char * );
		void	 activate_signal_bool( const char *signal, bool );
		void	 activate_signal_string( const char *signal, QString );
		void	 activate_signal_strref( const char *signal, const QString & );

		const QObject *sender();


		virtual void initMetaObject();
		static QMetaObject* staticMetaObject();

		virtual void timerEvent( QTimerEvent * );
		virtual void childEvent( QChildEvent * );

		virtual void connectNotify( const char *signal );
		virtual void disconnectNotify( const char *signal );
		virtual bool checkConnectArgs( const char *signal, const QObject *receiver,
				   const char *member );
		static QCString normalizeSignalSlot( const char *signalSlot );

		static  void badSuperclassWarning( const char *className,
				       const char *superclassName );
/*
private:
		uint	isSignal   : 1;
		uint	isWidget   : 1;
		uint	pendTimer  : 1;
		uint	pendEvent  : 1;
		uint	blockSig   : 1;
		uint	wasDeleted : 1;
		uint	isTree : 1;

		QMetaObject *queryMetaObject() const;
		static QMetaObject *metaObj;
		const char	*objname;
		QObject	*parentObj;
		QObjectList *childObjects;
		QSignalDict *connections;
		QObjectList *senderObjects;
		QObjectList *eventFilters;
		QObject	*sigSender;

		friend class QApplication;
		friend class QBaseApplication;
		friend class QWidget;
		friend class QSignal;
		friend class QSenderObject;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QObject( const QObject & );
		QObject &operator=( const QObject & );
#endif
*/
public: 
		// obsolete
		QStringList  superClasses( bool includeThis = FALSE ) const; // obsolete, remove 3.0
};
