/****************************************************************************
** $Id: qmenubar.i,v 1.1.1.1 2002/12/22 14:20:08 taka-hr Exp $
**
** Definition of QMenuBar class
**
** Created : 941209
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/


#ifndef QMENUBAR_H
#define QMENUBAR_H

#ifndef QT_H
#include "qpopupmenu.h"
#endif // QT_H

class QMenuBar : public QFrame, public QMenuData
{
//    Q_OBJECT
/*
		Q_ENUMS( Separator )
		Q_PROPERTY( Separator separator READ separator WRITE setSeparator )
		Q_PROPERTY( bool defaultUp READ isDefaultUp WRITE setDefaultUp )
*/	
public:
		QMenuBar( QWidget *parent=0, const char *name=0 );
//   ~QMenuBar();

		void	updateItem( int id );

		void	show();				// reimplemented show
		void	hide();				// reimplemented hide

		bool	eventFilter( QObject *, QEvent * );

		int		heightForWidth(int) const;

		enum	Separator { Never=0, InWindowsStyle=1 };
		Separator 	separator() const;
		virtual void	setSeparator( Separator when );
		
		void	setDefaultUp( bool );
		bool	isDefaultUp() const;

		bool customWhatsThis() const;

		QSize sizeHint() const;
		QSize minimumSize() const;
		QSize minimumSizeHint() const;

// QMenuData methods


		uint	count() const;

		%extend {
		int insertItem(VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil,
		 VALUE varg3=Qnil, VALUE varg4=Qnil, VALUE varg5=Qnil, VALUE varg6=Qnil) {
		 //char* cstr= 0;
		 char* member= 0;
		 QObject* qobj= 0;
		 QString* qstr= 0;
		 QIconSet* qiset= 0;
		 QPixmap* qpixmap= 0;
		 QPixmap* qpixmap2= 0;
		 QWidget* qwidget= 0;
		 int id=-1,index= -1,accel= 0,menuid;
		 QPopupMenu* qmenu= 0;
		 QCustomMenuItem* qcmenuitem= 0;
//    int insertItem( const QString &text,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString)  || TYPE(varg0) == T_NIL)
				 && ((rb_obj_is_kind_of(varg1,cQObject)  || TYPE(varg1) == T_NIL))
				 && (TYPE(varg2) == T_STRING)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)) {
						qstr = (QString *)Get_QString(varg0);
						qobj = (QObject *)Get_QObject(varg1);
						member = STR2CSTR(varg2);
						if(varg3 != Qnil) accel = NUM2INT(varg3);
						if(varg4 != Qnil) id = NUM2INT(varg4);
						if(varg5 != Qnil) index = NUM2INT(varg5);
						menuid = self->insertItem(*qstr,qobj,member,accel,id,index);
						QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg1,member);
						return menuid;
						}
//    int insertItem( const QIconSet& icon,
//                    const QString &text,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet)  || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString)  || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQObject) || TYPE(varg2) == T_NIL)
				 && (TYPE(varg3) == T_STRING)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)
				 && (varg6 == Qnil || TYPE(varg6) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else{
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 qobj = (QObject *)Get_QObject(varg2);
				 member = STR2CSTR(varg3);
				 if(varg4 != Qnil) accel = NUM2INT(varg4);
				 if(varg5 != Qnil) id = NUM2INT(varg5);
				 if(varg6 != Qnil) index = NUM2INT(varg6);
				 if(qpixmap != 0) menuid = self->insertItem(*qpixmap,*qstr,qobj,member,accel,id,index);
				 else menuid = self->insertItem(*qiset,*qstr,qobj,member,accel,id,index);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg2,member);
				 return menuid;
				 }
//    int insertItem( const QPixmap &pixmap,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap)   || TYPE(varg0) == T_NIL)
				 && ((rb_obj_is_kind_of(varg1,cQObject) || TYPE(varg1) == T_NIL))
				 && (TYPE(varg2) == T_STRING)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 qobj = (QObject *)Get_QObject(varg1);
				 member = STR2CSTR(varg2);
				 if(varg3 != Qnil) accel = NUM2INT(varg3);
				 if(varg4 != Qnil) id = NUM2INT(varg4);
				 if(varg5 != Qnil) index = NUM2INT(varg5);
				 menuid = self->insertItem(*qpixmap,qobj,member,accel,id,index);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg1,member);
				 return menuid;
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap,
//                    const QObject *receiver, const char* member,
//                    int accel = 0, int id = -1, int index = -1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet)|| TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap)|| TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQObject) || TYPE(varg2) == T_NIL)
				 && TYPE(varg3) == T_STRING
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)
				 && (varg5 == Qnil || TYPE(varg5) == T_FIXNUM)
				 && (varg6 == Qnil || TYPE(varg6) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 qobj = (QObject *)Get_QObject(varg2);
				 member = STR2CSTR(varg3);
				 if(varg4 != Qnil) accel = NUM2INT(varg4);
				 if(varg5 != Qnil) id = NUM2INT(varg5);
				 if(varg6 != Qnil) index = NUM2INT(varg6);
				 if(qpixmap2 != 0) self->insertItem(*qpixmap,*qpixmap,qobj,member,accel,id,index);
				 menuid = self->insertItem(*qiset,*qpixmap,qobj,member,accel,id,index);
				 QRObject::connect_rslot_menuId(self,SIGNAL(activated(int)),menuid,varg2,member);
				 return menuid;
				 }
//    int  insertItem( const QString &text, int id=-1, int index=-1 );
			else if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qstr = (QString *)Get_QString(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(*qstr,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                      const QString &text, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString)|| TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else { 
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,*qstr,id,index);
				 else return self->insertItem(*qiset,*qstr,id,index);
				 }
//    int insertItem( const QString &text, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
		 else if((TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString)|| TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPopupMenu)|| TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 qstr = (QString *)Get_QString(varg0);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 return self->insertItem(*qstr,qmenu,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QString &text, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet)|| TYPE(varg0) == T_NIL)
				 && (TYPE(varg1) == T_STRING || rb_obj_is_kind_of(varg1,cQString)|| TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQPopupMenu))|| TYPE(varg2) == T_NIL
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else{ 
						qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qstr = (QString *)Get_QString(varg1);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg2);
				 if(varg3 != Qnil) id = NUM2INT(varg3);
				 if(varg4 != Qnil) index = NUM2INT(varg4);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,*qstr,qmenu,id,index);
				 else return self->insertItem(*qiset,*qstr,qmenu,id,index);
				 }
//    int insertItem( const QPixmap &pixmap, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQPixmap)|| TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(*qpixmap,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap, int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet)|| TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap) || TYPE(varg0) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap2 != 0) self->insertItem(*qpixmap,*qpixmap2,id,index);
				 else self->insertItem(*qiset,*qpixmap,id,index);
				 }
//    int insertItem( const QPixmap &pixmap, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPopupMenu)  || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 return self->insertItem(*qpixmap,qmenu,id,index);
				 }
//    int insertItem( const QIconSet& icon,
//                    const QPixmap &pixmap, QPopupMenu *popup,
//                    int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet)|| TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQPixmap) || TYPE(varg1) == T_NIL)
				 && (rb_obj_is_kind_of(varg2,cQPopupMenu)|| TYPE(varg2) == T_NIL)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)
				 && (varg4 == Qnil || TYPE(varg4) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						qpixmap = (QPixmap *)Get_QPixmap(varg0);
						qpixmap2 = (QPixmap *)Get_QPixmap(varg1);
				 } else {
						qiset = (QIconSet *)Get_QIconSet(varg0);
						qpixmap = (QPixmap *)Get_QPixmap(varg1);
				 }
				 qmenu = (QPopupMenu *)Get_QPopupMenu(varg2);
				 if(varg3 != Qnil) id = NUM2INT(varg3);
				 if(varg4 != Qnil) index = NUM2INT(varg4);
				 if(qpixmap2 != 0) return self->insertItem(*qpixmap,*qpixmap2,qmenu,id,index);
				 else return self->insertItem(*qiset,*qpixmap,qmenu,id,index);
				 }

//    int insertItem( QWidget* widget, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQWidget)  || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qwidget = (QWidget *)Get_QWidget(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(qwidget,id,index);
				 }
//    int insertItem( const QIconSet& icon, QCustomMenuItem* custom, int id=-1, int index=-1 );
			else if((rb_obj_is_kind_of(varg0,cQPixmap) || rb_obj_is_kind_of(varg0,cQIconSet) || TYPE(varg0) == T_NIL)
				 && (rb_obj_is_kind_of(varg1,cQCustomMenuItem)  || TYPE(varg1) == T_NIL)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)
				 && (varg3 == Qnil || TYPE(varg3) == T_FIXNUM)) {
				 if(rb_obj_is_kind_of(varg0,cQPixmap)) {
						 qpixmap = (QPixmap *)Get_QPixmap(varg0);
				 } else {
						 qiset = (QIconSet *)Get_QIconSet(varg0);
				 }
				 qcmenuitem = (QCustomMenuItem *)Get_QCustomMenuItem(varg1);
				 if(varg2 != Qnil) id = NUM2INT(varg2);
				 if(varg3 != Qnil) index = NUM2INT(varg3);
				 if(qpixmap != 0) return self->insertItem(*qpixmap,qcmenuitem,id,index);
				 else return self->insertItem(*qiset,qcmenuitem,id,index);
				 }
//    int insertItem( QCustomMenuItem* custom, int id=-1, int index=-1 );
		 else if((rb_obj_is_kind_of(varg0,cQCustomMenuItem)  || TYPE(varg0) == T_NIL)
				 && (varg1 == Qnil || TYPE(varg1) == T_FIXNUM)
				 && (varg2 == Qnil || TYPE(varg2) == T_FIXNUM)) {
				 qcmenuitem = (QCustomMenuItem *)Get_QCustomMenuItem(varg0);
				 if(varg1 != Qnil) id = NUM2INT(varg1);
				 if(varg2 != Qnil) index = NUM2INT(varg2);
				 return self->insertItem(qcmenuitem,id,index);
				 }
		else {
				 rb_raise(rb_eArgError,"Argment error in insertItem(..) no match argments");
				 return -1;
				}
			return -1;
		}
			
		}
		
/*
		%name(insertItemQObject) int		insertItem( const QString &text,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );
		%name(insertItemQIconSetQObject) int		insertItem( const QIconSet& icon,
			    const QString &text,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );
		%name(QPixmapQObject) int		insertItem( const QPixmap &pixmap,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );
		%name(QIconSetQPixmapQObject) int		insertItem( const QIconSet& icon,
			    const QPixmap &pixmap,
			    const QObject *receiver, const char* member,
			    int accel = 0, int id = -1, int index = -1 );




		%name(insertItemQString) int	insertItem( const QString &text, int id=-1, int index=-1 );
		%name(insertItemQIconSetId) int		insertItem( const QIconSet& icon,
			    const QString &text, int id=-1, int index=-1 );

		int		insertItem( const QString &text, QPopupMenu *popup,
			    int id=-1, int index=-1 );
		%name(insertItemQIconSetQPopupMenu) int		insertItem( const QIconSet& icon,
			    const QString &text, QPopupMenu *popup,
			    int id=-1, int index=-1 );


		%name(insertItemQPixmapId) int		insertItem( const QPixmap &pixmap, int id=-1, int index=-1 );
		%name(insertItemQIconSetQPixmapId) int		insertItem( const QIconSet& icon,
			    const QPixmap &pixmap, int id=-1, int index=-1 );
		%name(insertItemQPixmapQPopupMenu) int		insertItem( const QPixmap &pixmap, QPopupMenu *popup,
			    int id=-1, int index=-1 );
		%name(insertItemQIconSetQPixmapQPopupMenu) int		insertItem( const QIconSet& icon,
			    const QPixmap &pixmap, QPopupMenu *popup,
			    int id=-1, int index=-1 );

		%name(insertItemQWidgetId) int		insertItem( QWidget* widget, int id=-1, int index=-1 );

		%name(insertItemQIconSetQCustomMenuItem) int		insertItem( const QIconSet& icon, QCustomMenuItem* custom, int id=-1, int index=-1 );
		%name(insertQCustomMenuItemId) int		insertItem( QCustomMenuItem* custom, int id=-1, int index=-1 );

*/
		int		insertSeparator( int index=-1 );

		void	removeItem( int id )		{ removeItemAt(indexOf(id)); }
		void	removeItemAt( int index );
		void	clear();

		int		accel( int id )		const;
		void	setAccel( int key, int id );

		QIconSet    *iconSet( int id )	const;
		QString text( int id )		const;
		QPixmap    *pixmap( int id )	const;

		void setWhatsThis( int id, const QString& );
		QString whatsThis( int id ) const;


//    void	changeItem( int id, const QString &text );
		//RENAME %name(changeItemQPixmap) void	changeItem( int id, const QPixmap &pixmap );
		//RENAME %name(changeItemQIconSet) void	changeItem( int id, const QIconSet &icon, const QString &text );
		//RENAME %name(changeItemQIconSetQPixmap) void	changeItem( int id, const QIconSet &icon, const QPixmap &pixmap );
		%extend {
			 void changeItem(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					int id;
					id = NUM2INT(varg0);
					QString* text;
					if(rb_obj_is_kind_of(varg1,cQPixmap)) {
						 QPixmap* pixmap;
						 pixmap = (QPixmap *)Get_QPixmap(varg1);
						 if(varg2 != Qnil) {
								 if(rb_obj_is_kind_of(varg2,cQPixmap)) {
										 QPixmap* pixmap2;
										 pixmap2 = (QPixmap *)Get_QPixmap(varg2);
										 self->changeItem(id,*pixmap,*pixmap2);
								 } else {             
										 text = (QString *)Get_QString(varg2);
										 self->changeItem(id,*pixmap,*text);
								 }
						 }else {
								 self->changeItem(id,*pixmap);
						 }
					} else if(rb_obj_is_kind_of(varg1,cQIconSet)) {
						 QIconSet* qic;
						 QPixmap* pixmap;
						 qic = (QIconSet *)Get_QIconSet(varg1);
						 pixmap = (QPixmap *)Get_QPixmap(varg2);
						 self->changeItem(id,*qic,*pixmap);
					} else {
						 rb_raise(rb_eArgError,"Error in changeItem argments");
					}
			 }
		}


//    void	changeItem( const QString &text, int id ); // obsolete
//    void	changeItem( const QPixmap &pixmap, int id ); // obsolete
//    void	changeItem( const QIconSet &icon, const QString &text, int id ); // obsolete


		bool	isItemEnabled( int id ) const;
		void	setItemEnabled( int id, bool enable );

		bool	isItemChecked( int id ) const;
		void	setItemChecked( int id, bool check );

//    virtual void updateItem( int id );

		int		indexOf( int id )	const;
		int		idAt( int index )	const;
		virtual void	setId( int index, int id );

		bool	connectItem( int id,
			     const QObject *receiver, const char* member );
		bool	disconnectItem( int id,
				const QObject *receiver, const char* member );

		bool	setItemParameter( int id, int param );
		int	itemParameter( int id ) const;

		QMenuItem  *findItem( int id )	const;
		//%name(findItemQMenuData) QMenuItem  *findItem( int id, QMenuData ** parent )	const;



/*
signals:
		void	activated( int itemId );
		void	highlighted( int itemId );

protected:
		void	drawContents( QPainter * );
		void	fontChange( const QFont & );
		void	mousePressEvent( QMouseEvent * );
		void	mouseReleaseEvent( QMouseEvent * );
		void	mouseMoveEvent( QMouseEvent * );
		void	keyPressEvent( QKeyEvent * );
		void	focusInEvent( QFocusEvent * );
		void	focusOutEvent( QFocusEvent * );
		void	resizeEvent( QResizeEvent * );
		void	leaveEvent( QEvent * );
		void	menuContentsChanged();
		void	menuStateChanged();
		void 	styleChange( QStyle& );

private slots:
		void	subActivated( int itemId );
		void	subHighlighted( int itemId );
		void	accelActivated( int itemId );
		void	accelDestroyed();

private:
		void	menuInsPopup( QPopupMenu * );
		void	menuDelPopup( QPopupMenu * );
		void	frameChanged();

		bool	tryMouseEvent( QPopupMenu *, QMouseEvent * );
		void	tryKeyEvent( QPopupMenu *, QKeyEvent * );
		void	goodbye( bool cancelled = FALSE );
		void	openActPopup();
		void	hidePopups();

		virtual void	setActItem( int, bool = FALSE );
		virtual void	setWindowsAltMode( bool, int = 0 );

		void setActiveItem( int index, bool show = TRUE, bool activate_first_item = TRUE );
		void setAltMode( bool );

		int		calculateRects( int max_width = -1 );
		int		itemAtPos( const QPoint & );
		QRect	itemRect( int item );

		void	setupAccelerators();
		QAccel     *autoaccel;
		QRect      *irects;
		int		rightSide;

		uint	mseparator : 1;
		uint	waitforalt : 1;
		uint	popupvisible  : 1;
		uint	hasmouse : 1;
		uint 	defaultup : 1;
		uint 	toggleclose : 1;

		friend class QPopupMenu;

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QMenuBar( const QMenuBar & );
		QMenuBar &operator=( const QMenuBar & );
#endif
*/
};


#endif // QMENUBAR_H
