/****************************************************************************
** $Id: qmainwindow.i,v 1.1.1.1 2002/12/22 14:20:07 taka-hr Exp $
**
** Definition of QMainWindow class
**
** Created : 980316
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QMAINWINDOW_H
#define QMAINWINDOW_H

#ifndef QT_H
#include "qwidget.h"
#endif // QT_H


class QMenuBar;
class QToolBar;
class QStatusBar;
class QToolTipGroup;

//template <class type> class QList;

class QMainWindowPrivate;

class QMainWindow: public QWidget
{
//    Q_OBJECT
/*
		Q_PROPERTY( bool rightJustification READ rightJustification WRITE setRightJustification )
		Q_PROPERTY( bool usesBigPixmaps READ usesBigPixmaps WRITE setUsesBigPixmaps )
		Q_PROPERTY( bool usesTextLabel READ usesTextLabel WRITE setUsesTextLabel )
		Q_PROPERTY( bool toolBarsMovable READ toolBarsMovable WRITE setToolBarsMovable )
		Q_PROPERTY( bool opaqueMoving READ opaqueMoving WRITE setOpaqueMoving )
*/
public:
		QMainWindow( QWidget * parent = 0, const char * name = 0, WFlags f = WType_TopLevel );
//    ~QMainWindow();

		QMenuBar * menuBar() const;
		QStatusBar * statusBar() const;
		QToolTipGroup * toolTipGroup() const;

		virtual void setCentralWidget( QWidget * );
		QWidget * centralWidget() const;

		enum ToolBarDock { Unmanaged, TornOff, Top, Bottom, Right, Left, Minimized };

		//RENAME %name(setDockEnabledToolBarDock) virtual void setDockEnabled( ToolBarDock dock, bool enable );
		//RENAME %name(isDockEnabledToolBarDock) bool isDockEnabled( ToolBarDock dock ) const;
//    void setDockEnabled( QToolBar *tb, ToolBarDock dock, bool enable ); // ########### make virtual
//    bool isDockEnabled( QToolBar *tb, ToolBarDock dock ) const;
	 %extend {
			void setDockEnabled(VALUE varg0,VALUE varg1,VALUE varg2=Qnil) {
							 QMainWindow::ToolBarDock dock;
							 bool enable;
							 if(rb_obj_is_kind_of(varg0,cQToolBar)) {
									QToolBar* tb;
									tb = (QToolBar *)Get_QToolBar(varg0);
									dock = (QMainWindow::ToolBarDock)NUM2INT(varg1);
									enable = (varg2 == Qtrue) ? TRUE:FALSE;
									self->setDockEnabled(tb,dock,enable);
							 } else {
									dock = (QMainWindow::ToolBarDock)NUM2INT(varg0);
									enable = (varg1 == Qtrue) ? TRUE:FALSE;
									self->setDockEnabled(dock,enable);
							 }
						}
			 bool isDockEnabled(VALUE varg0,VALUE varg1=Qnil) {
							 QMainWindow::ToolBarDock dock;
							 if(rb_obj_is_kind_of(varg0,cQToolBar)) {
									QToolBar* tb;
									tb = (QToolBar *)Get_QToolBar(varg0);
									dock = (QMainWindow::ToolBarDock)NUM2INT(varg1);
									return self->isDockEnabled(tb,dock);
							 } else {
									dock = (QMainWindow::ToolBarDock)NUM2INT(varg0);
									return self->isDockEnabled(dock);
							 }
						}
				 }
										 


//    void addToolBar( QToolBar *, ToolBarDock tbd = Top, bool newLine = FALSE );
		//RENAME %name(addToolBarQString) void addToolBar( QToolBar *, const QString &label,
		//RENAME		     ToolBarDock tbd = Top, bool newLine = FALSE );
//    void moveToolBar( QToolBar *, ToolBarDock tbd = Top );
		//RENAME %name(moveToolBarIndex) void moveToolBar( QToolBar *, ToolBarDock, bool nl, int index, int extraOffset = -1 );
		%extend {
				 void addToolBar(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,
								VALUE varg3=Qnil) {
						QToolBar* qtb;
						qtb = (QToolBar *)Get_QToolBar(varg0);
						QMainWindow::ToolBarDock tbd=QMainWindow::Top;
						bool newLine=FALSE;
						if(rb_obj_is_kind_of(varg1,cQString) || TYPE(varg1) == T_STRING) {
								QString* label;
								label = (QString *)Get_QString(varg1);
								if(varg2 != Qnil) 
										tbd = (QMainWindow::ToolBarDock)NUM2INT(varg2);
								if(varg3 != Qnil)
										newLine = (varg3 == Qtrue) ? TRUE:FALSE;
								self->addToolBar(qtb,*label,tbd,newLine);
						} else {
								if(varg1 != Qnil) 
										tbd = (QMainWindow::ToolBarDock)NUM2INT(varg1);
								if(varg2 != Qnil)
										newLine = (varg2 == Qtrue) ? TRUE:FALSE;
								self->addToolBar(qtb,tbd,newLine);
						}
				 }
			void moveToolBar(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil,
											 VALUE varg3=Qnil,VALUE varg4=Qnil) {
					 QToolBar* qtb;
					 qtb = (QToolBar *)Get_QToolBar(varg0);
					 QMainWindow::ToolBarDock tbd=QMainWindow::Top;
					 if(varg2 == Qnil) {
							if(varg1 != Qnil) 
									tbd = (QMainWindow::ToolBarDock)NUM2INT(varg1);
							self->moveToolBar(qtb,tbd);
					 } else {
							int index;
							int extraOffset=-1;
							bool nl;
							tbd = (QMainWindow::ToolBarDock)NUM2INT(varg1);
							nl = (varg2 == Qtrue) ? TRUE:FALSE;
							index = NUM2INT(varg3);
							if(varg4 != Qnil)
									extraOffset = NUM2INT(varg4);
							self->moveToolBar(qtb,tbd,nl,index,extraOffset);
					 }
				}
		 }
					 
		void removeToolBar( QToolBar * );


		void show();
		QSize sizeHint() const;
		QSize minimumSizeHint() const;

		bool rightJustification() const;
		bool usesBigPixmaps() const;
		bool usesTextLabel() const;
		bool toolBarsMovable() const;
		bool opaqueMoving() const;

		bool eventFilter( QObject*, QEvent* );

		//bool getLocation( QToolBar *tb, ToolBarDock &dock, int &index, bool &nl, int &extraOffset ) const;
%extend {
	 bool getLocation(VALUE tb, VALUE dock, VALUE index, VALUE nl, VALUE extraOffset) {
			QToolBar* ctb;
			QMainWindow::ToolBarDock cdock;
			int cindex;
			bool cnl;
			int cextraOffset;
			ctb = (QToolBar *)Get_QToolBar(tb);
			cdock = (QMainWindow::ToolBarDock)NUM2INT(dock);
			cindex = NUM2INT(index);
			if(nl == Qtrue) cnl = TRUE;
			else cnl = FALSE;
			cextraOffset = NUM2INT(extraOffset);
			return self->getLocation(ctb,cdock,cindex,cnl,cextraOffset);
			}
	 }

//    QList<QToolBar> toolBars( ToolBarDock dock ) const;
		QList_QToolBar toolBars(ToolBarDock dock) const;
		void lineUpToolBars( bool keepNewLines = FALSE );

		bool isDockMenuEnabled() const;

//public slots:
		virtual void setRightJustification( bool );
		virtual void setUsesBigPixmaps( bool );
		void setUsesTextLabel( bool ); // virtual 3.0
		void setToolBarsMovable( bool ); // virtual 3.0
		void setOpaqueMoving( bool ); // virtual 3.0
		void setDockMenuEnabled( bool );

		void whatsThis();
/*
signals:
		void pixmapSizeChanged( bool );
		void usesTextLabelChanged( bool );
		void startMovingToolBar( QToolBar * );
		void endMovingToolBar( QToolBar * );
		void toolBarPositionChanged( QToolBar * );

protected slots:
		virtual void setUpLayout();

protected:
		void paintEvent( QPaintEvent * );
		void resizeEvent( QResizeEvent * );
		void childEvent( QChildEvent * );
		bool event( QEvent * );
		void styleChange( QStyle& );

private:
		QMainWindowPrivate * d;
		void triggerLayout( bool deleteLayout = TRUE);
		void moveToolBar( QToolBar *, QMouseEvent * );
		void rightMouseButtonMenu( const QPoint &p );

		virtual void setMenuBar( QMenuBar * );
		virtual void setStatusBar( QStatusBar * );
		virtual void setToolTipGroup( QToolTipGroup * );
		ToolBarDock findDockArea( const QPoint &pos, QRect &rect, QToolBar *tb, QRect *dockRect = 0 );
		void moveToolBar( QToolBar *, ToolBarDock, QToolBar *relative, int ipos );

		friend class QToolBar;
		friend class QMenuBar;
		friend class QHideDock;
private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QMainWindow( const QMainWindow & );
		QMainWindow& operator=( const QMainWindow & );
#endif
*/
};


#endif
