/****************************************************************************
** $Id: qfiledialog.i,v 1.1.1.1 2002/12/22 14:20:03 taka-hr Exp $
**
** Definition of QFileDialog class
**
** Created : 950428
**
** Copyright (C) 1992-2000 Troll Tech AS.  All rights reserved.
**
** This file is part of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Troll Tech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** Licensees holding valid Qt Professional Edition licenses may use this
** file in accordance with the Qt Professional Edition License Agreement
** provided with the Qt Professional Edition.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
** information about the Professional Edition licensing, or see
** http://www.trolltech.com/qpl/ for QPL licensing information.
**
*****************************************************************************/

//#ifndef QFILEDIALOG_H
//#define QFILEDIALOG_H

struct QFileDialogPrivate;
class QPushButton;
class QLabel;
class QWidget;
class QFileDialog;
class QTimer;
class QNetworkOperation;

//#ifndef QT_H
//#include "qdir.h"
//#include "qdialog.h"
//#include "qlistbox.h"
//#include "qlineedit.h"
//#include "qlistview.h"
//#include "qurloperator.h"
//#include "qurlinfo.h"
//#endif // QT_H


class QFileIconProvider : public QObject
{
//    Q_OBJECT
public:
		QFileIconProvider( QObject * parent = 0, const char* name = 0 );
		virtual const QPixmap * pixmap( const QFileInfo & );
/*
private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QFileIconProvider( const QFileIconProvider & );
		QFileIconProvider& operator=( const QFileIconProvider & );
#endif
*/
};

class QFilePreview
{
public:
		//QFilePreview();
		//virtual void previewUrl( const QUrl &url ) = 0;

};

class QFileDialog : public QDialog
{
//    friend class QFileListBox;
//    friend class QFileListView;
/*
		Q_OBJECT
		Q_ENUMS( Mode ViewMode PreviewMode )
		// ##### Why are this readonly properties ?
		Q_PROPERTY( QString selectedFile READ selectedFile )
		Q_PROPERTY( QString selectedFilter READ selectedFilter )
		Q_PROPERTY( QStringList selectedFiles READ selectedFiles )
		// #### Should not we be able to set the path ?
		Q_PROPERTY( QString dirPath READ dirPath )
		Q_PROPERTY( bool showHiddenFiles READ showHiddenFiles WRITE setShowHiddenFiles )
		Q_PROPERTY( Mode mode READ mode WRITE setMode )
		Q_PROPERTY( ViewMode viewMode READ viewMode WRITE setViewMode )
		Q_PROPERTY( PreviewMode previewMode READ previewMode WRITE setPreviewMode )
		Q_PROPERTY( bool infoPreview READ isInfoPreviewEnabled WRITE setInfoPreviewEnabled )
		Q_PROPERTY( bool contentsPreview READ isContentsPreviewEnabled WRITE setContentsPreviewEnabled )
*/
public:
		QFileDialog( const QString& dirName, const QString& filter = QString::null,
								 QWidget *parent=0, const char *name = 0, bool modal = FALSE );
//    QFileDialog( QWidget *parent=0, const char *name = 0, bool modal = FALSE );
		~QFileDialog();

		// recommended static functions

//const char* name () const; //dummy for swig

		static QString getOpenFileName( const QString &initially = QString::null,
				    const QString &filter = QString::null,
				    QWidget *parent = 0, const char* name = 0, const QString& caption=QString::null ); // ## merge 3.0
//    static QString getOpenFileName( const QString &initially,
//				    const QString &filter,
//				    QWidget *parent, const char* name, const QString& caption );
		static QString getSaveFileName( const QString &initially = QString::null,
				    const QString &filter = QString::null,
				    QWidget *parent = 0, const char* name = 0, const QString& caption=QString::null);// ## merge 3.0
//    static QString getSaveFileName( const QString &initially,
//				    const QString &filter,
//				    QWidget *parent, const char* name, 
//				    const QString& caption);
		static QString getExistingDirectory( const QString &dir = QString::null,
					 QWidget *parent = 0,
					 const char* name = 0 , const QString& caption=QString::null);// ## merge 3.0
//    static QString getExistingDirectory( const QString &dir,
//					 QWidget *parent,
//					 const char* name,
//					 const QString& caption);
		static QStringList getOpenFileNames( const QString &filter= QString::null,
					 const QString &dir = QString::null,
					 QWidget *parent = 0,
					 const char* name = 0, const QString& caption=QString::null);// ## merge 3.0
//    static QStringList getOpenFileNames( const QString &filter,
//					 const QString &dir,
//					 QWidget *parent,
//					 const char* name,
//					 const QString& caption);


		// other static functions

		static void setIconProvider( QFileIconProvider * );
		static QFileIconProvider * iconProvider();

		// non-static function for special needs

		QString selectedFile() const;
		QString selectedFilter() const;
		void setSelection( const QString &);

		void selectAll( bool b );

		QStringList selectedFiles() const;

		QString dirPath() const;

//    void setDir( const QDir & );
		const QDir *dir() const;

		void setShowHiddenFiles( bool s );
		bool showHiddenFiles() const;

		void rereadDir();
		void resortDir();

		enum Mode { AnyFile, ExistingFile, Directory, ExistingFiles };
		void setMode( Mode );
		Mode mode() const;

		enum ViewMode { Detail, List };
		enum PreviewMode { NoPreview, Contents, Info };
		void setViewMode( ViewMode m );
		ViewMode viewMode() const;
		void setPreviewMode( PreviewMode m );
		PreviewMode previewMode() const;

		bool eventFilter( QObject *, QEvent * );

		bool isInfoPreviewEnabled() const;
		bool isContentsPreviewEnabled() const;
		void setInfoPreviewEnabled( bool );
		void setContentsPreviewEnabled( bool );

		void setInfoPreview( QWidget *w, QFilePreview *preview );
		void setContentsPreview( QWidget *w, QFilePreview *preview );

		QUrl url() const;

//public slots:
		//RENAME %name(setDirQString) void setDir( const QString& );
		%extend {
			 void setDir(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQDir)) {
						 QDir* qdir;
						 qdir = (QDir *)Get_QDir(varg0);
						 self->setDir(*qdir);
					} else {
						 QString *qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setDir(*qstr);
					}
			 }
		}   
		void setUrl( const QUrlOperator &url );
		void setFilter( const QString& );
//    void setFilters( const QString& );
		//RENAME %name(setFiltersArray) void setFilters( const char ** );
		//RENAME %name(setFiltersQStringList) void setFilters( const QStringList& );
		%extend {
			 void setFilters(VALUE varg0) {
					if(rb_obj_is_kind_of(varg0,cQStringList)) {
						 QStringList *qstrlist;
						 qstrlist = (QStringList *)Get_QStringList(varg0);
						 self->setFilters(*qstrlist);
					} else if(TYPE(varg0) == T_ARRAY) {
						 int a_size = RARRAY(varg0)->len;
						 char** ar_str = ALLOC_N(char *,a_size);
						 for(int i=0; i<a_size; i++) {
								ar_str[i] = STR2CSTR(RARRAY(varg0)->ptr[i]);
						 }
						 self->setFilters((const char**)ar_str);
					} else {
						 QString *qstr;
						 qstr = (QString *)Get_QString(varg0);
						 self->setFilters(*qstr);
					}
			 }
		}

/*
protected:
		void resizeEvent( QResizeEvent * );
		void keyPressEvent( QKeyEvent * );

		void addWidgets( QLabel *, QWidget *, QPushButton * );
		void addToolButton( QButton *b, bool separator = FALSE );
		void addLeftWidget( QWidget *w );
		void addRightWidget( QWidget *w );
		void addFilter( const QString &filter );

signals:
		void fileHighlighted( const QString& );
		void fileSelected( const QString& );
		void dirEntered( const QString& );

private slots:
		void detailViewSelectionChanged();
		void listBoxSelectionChanged();
		void changeMode( int );
		void fileNameEditReturnPressed();
		void stopCopy();
		void removeProgressDia();

		void fileSelected( int );
		void fileHighlighted( int );
		void dirSelected( int );
		void pathSelected( int );

		void updateFileNameEdit( QListViewItem *);
		void selectDirectoryOrFile( QListViewItem * );
		void popupContextMenu( QListViewItem *, const QPoint &, int );
		void popupContextMenu( QListBoxItem *, const QPoint & );
		void updateFileNameEdit( QListBoxItem *);
		void selectDirectoryOrFile( QListBoxItem * );
		void fileNameEditDone();

		void okClicked();
		void filterClicked(); // not used
		void cancelClicked();

		void cdUpClicked();
		void newFolderClicked();

		void fixupNameEdit();

		void doMimeTypeLookup();

		void updateGeometries();
		void modeButtonsDestroyed();
		void urlStart( QNetworkOperation *op );
		void urlFinished( QNetworkOperation *op );
		void dataTransferProgress( int bytesDone, int bytesTotal, QNetworkOperation * );
		void insertEntry( const QValueList<QUrlInfo> &fi, QNetworkOperation *op );
		void removeEntry( QNetworkOperation * );
		void createdDirectory( const QUrlInfo &info, QNetworkOperation * );
		void itemChanged( QNetworkOperation * );
		void goBack();

private:
		enum PopupAction {
				PA_Open = 0,
				PA_Delete,
				PA_Rename,
				PA_SortName,
				PA_SortSize,
				PA_SortType,
				PA_SortDate,
				PA_SortUnsorted,
				PA_Cancel,
				PA_Reload,
				PA_Hidden
		};

		void init();
		bool trySetSelection( bool isDir, const QUrlOperator &, bool );
		void deleteFile( const QString &filename );
		void popupContextMenu( const QString &filename, bool withSort,
													 PopupAction &action, const QPoint &p );

		QDir reserved; // was cwd
		QString fileName;

		QFileDialogPrivate *d;
		QFileListView  *files;

		QLineEdit  *nameEdit; // also filter
		QPushButton *okB;
		QPushButton *cancelB;

#if defined(_WS_WIN_)
		static QString winGetOpenFileName( const QString &initialSelection,
				       const QString &filter,
				       QString* workingDirectory,
				       QWidget *parent = 0,
				       const char* name = 0, 
				       const QString& caption = QString::null);
		static QString winGetSaveFileName( const QString &initialSelection,
				       const QString &filter,
				       QString* workingDirectory,
				       QWidget *parent = 0,
				       const char* name = 0,
				       const QString& caption = QString::null);
		static QStringList winGetOpenFileNames( const QString &filter,
					    QString* workingDirectory,
					    QWidget *parent = 0,
					    const char* name = 0,
					    const QString& caption = QString::null);
#endif

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QFileDialog( const QFileDialog & );
		QFileDialog &operator=( const QFileDialog & );
#endif
*/
};

//#endif // QFILEDIALOG_H
