/****************************************************************************
** $Id: qcheckbox.i,v 1.1.1.1 2002/12/22 14:20:00 taka-hr Exp $
**
** Definition of QCheckBox class
**
** Created : 940222
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the widgets module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

//#ifndef QCHECKBOX_H
//#define QCHECKBOX_H

//#ifndef QT_H
//#include "qbutton.h"
//#endif // QT_H

//#ifndef QT_NO_COMPLEXWIDGETS

class QCheckBox : public QButton
{
		//Q_OBJECT
		//Q_PROPERTY( bool checked READ isChecked WRITE setChecked )
		//Q_PROPERTY( bool tristate READ isTristate WRITE setTristate )

public:

	 %extend {
				 QCheckBox(VALUE varg0, VALUE varg1=Qnil, VALUE varg2=Qnil,
									VALUE varg3 =Qnil) {
				 if(rb_obj_is_kind_of(varg0,cQWidget)|| TYPE(varg0) == T_NIL) {
						QWidget* parent;
						char* name=0;
						parent = (QWidget*)Get_QWidget(varg0);
						if(varg1 != Qnil) name=STR2CSTR(varg1);
						return new QCheckBox(parent,name);
				 } else if(TYPE(varg0) == T_STRING || rb_obj_is_kind_of(varg0,cQString) || TYPE(varg0) == T_NIL) {
						QWidget* parent;
						QString* text;
						char* name=0;
						text = (QString*)Get_QString(varg0);
						parent = (QWidget*)Get_QWidget(varg1);
						if(varg2 != Qnil) name=STR2CSTR(varg2);
						return new QCheckBox(*text,parent,name);
				 } else {
						rb_raise(rb_eArgError,"Error in QRadioButton constructor");
				 }
			}
	 };               


//    QCheckBox( QWidget *parent, const char *name=0 );
//    QCheckBox( const QString &text, QWidget *parent, const char* name=0 );

		bool    isChecked() const;
		void    setChecked( bool check );

		void    setNoChange();

		void    setTristate(bool y=TRUE);
		bool    isTristate() const;

		QSize sizeHint() const;
		QSizePolicy sizePolicy() const;
/*
protected:
		void    resizeEvent( QResizeEvent* );
		void    drawButton( QPainter * );
		void    drawButtonLabel( QPainter * );
		void    updateMask();

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
		QCheckBox( const QCheckBox & );
		QCheckBox &operator=( const QCheckBox & );
#endif
*/
};

/*
inline bool QCheckBox::isChecked() const
{ return isOn(); }

inline void QCheckBox::setChecked( bool check )
{ setOn( check ); }


#endif // QT_NO_COMPLEXWIDGETS

#endif // QCHECKBOX_H
*/
