/****************************************************************************
** $Id: qapplication.i,v 1.1.1.1 2002/12/22 14:19:59 taka-hr Exp $
**
** Definition of QApplication class
**
** Created : 931107
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/


#ifndef QAPPLICATION_H
#define QAPPLICATION_H

#ifndef QT_H
#include "qwidget.h"
#include "qasciidict.h"
#include "qpalette.h"
#include "qtranslator.h"
#endif // QT_H

class QStyle;
class QTranslator;
#if defined(_WS_QWS_)
class QWSDecoration;
#endif
//template <class type> class QList;

class QApplication;
//extern QApplication *qApp;		// global application object



class QApplication : public QObject
{
public:

		%extend {
		QApplication(VALUE vargv) {
	if (TYPE(vargv) != T_ARRAY) rb_raise(rb_eArgError, "Array expected");
	int argc = RARRAY(vargv)->len;
	char **argv = new char*[argc];
	for (int i = 0; i < argc; i++) {
	    VALUE v = RARRAY(vargv)->ptr[i];
	    if (TYPE(v) != T_STRING)
		rb_raise(rb_eArgError, "Array of String expected");
	    argv[i] = new char[RSTRING(v)->len + 1];
	    strcpy(argv[i], RSTRING(v)->ptr);
	}
	return new QApplication(argc, argv);
		}
	 static QApplication* qApp(){
	 return qApp;
	 }
	}



//    QApplication( int &argc, char **argv);
//    QApplication( int &argc, char **argv, bool GUIenabled );
		enum Type { Tty, GuiClient, GuiServer };
#if defined(_WS_X11_)
//    QApplication( Display* dpy );
//    QApplication( Display *dpy, int argc, char **argv);
#endif
//    virtual ~QApplication();

//    int		    argc()	const;
//    char	  **argv()	const;

		static QStyle  &style();
		static void	    setStyle( QStyle* );

//#if 1	/* OBSOLETE */
//    enum ColorMode { NormalColors, CustomColors };
//    static ColorMode colorMode();
//    static void      setColorMode( QApplication::ColorMode );
//#endif

		enum ColorSpec { NormalColor=0, CustomColor=1, ManyColor=2 };
		static int	     colorSpec();
		static void      setColorSpec( int );

#ifndef QT_NO_CURSOR
		static QCursor  *overrideCursor();
		static void	     setOverrideCursor( const QCursor &, bool replace=FALSE );
		static void	     restoreOverrideCursor();
#endif


#ifndef QT_NO_PALETTE
		static QPalette  palette( const QWidget* qw= 0 );
		static void	     setPalette( const QPalette &, bool informWidgets=FALSE,
				 const char* className = 0 );
#endif
		static QFont     font( const QWidget* qw = 0 );
		static void	     setFont( const QFont &, bool informWidgets=FALSE,
			      const char* className = 0 );
		static QFontMetrics fontMetrics();

		QWidget	    *mainWidget()  const;
		virtual  void     setMainWidget( QWidget * );
		virtual   void     polish( QWidget * );

		static QWidgetList *allWidgets();
		static QWidgetList *topLevelWidgets();
		static QWidget     *desktop();
		static QWidget     *activePopupWidget();
		static QWidget     *activeModalWidget();
		static QClipboard  *clipboard();
		QWidget	       *focusWidget() const;
		QWidget	       *activeWindow() const;

//    static QWidget  *widgetAt( int x, int y, bool child=FALSE );
		//RENAME %name(widgetAtQPoint) static QWidget  *widgetAt( const QPoint &, bool child=FALSE );
		%extend {
			 static QWidget *widgetAt(VALUE varg0,VALUE varg1=Qnil,VALUE varg2=Qnil) {
					if(TYPE(varg0) == T_FIXNUM && TYPE(varg1) == T_FIXNUM) {
						 int x,y;
						 bool child=FALSE;
						 x = NUM2INT(varg0);
						 y = NUM2INT(varg1);
						 if(varg2 != Qnil) 
								 child = (varg2 == Qtrue) ? TRUE:FALSE;
						 return QApplication::widgetAt(x,y,child);
					 } else if(rb_obj_is_kind_of(varg0,cQPoint)) {
						 QPoint *qp;
						 bool child=FALSE;
						 qp = (QPoint*)Get_QPoint(varg0);
						 if(varg1 != Qnil)
								 child = (varg1 == Qtrue) ? TRUE:FALSE;
						 return QApplication::widgetAt(*qp,child);
					 } else {
						 rb_raise(rb_eArgError,"Error in widgetAt argments");
					 }
				}
		 }
						 
					 
		
		int		     exec();
		//void	     processEvents();
		//RENAME %name(processEventsInt) void     processEvents( int maxtime );
		%extend {
			 void processEvents(VALUE varg0=Qnil) {
					if(varg0==Qnil) {
						 self->processEvents();
					} else {
						 int maxtime;
						 maxtime = NUM2INT(varg0);
					}
			 }
		}
		
		void	     processOneEvent();
		int		     enter_loop();
		void	     exit_loop();
		int		     loopLevel() const;
		static void	     exit( int retcode=0 );

		static bool	     sendEvent( QObject *receiver, QEvent *event );
		static void	     postEvent( QObject *receiver, QEvent *event );
		//RENAME %name(sendPostedEventsQObj) static void sendPostedEvents( QObject *receiver, int event_type );
//    static void	     sendPostedEvents();
		%extend {
			 static void sendPostedEvents(VALUE varg0=Qnil,VALUE varg1=Qnil) {
					if(varg0 == Qnil) {
						 QApplication::sendPostedEvents();
					} else {
						 QObject* qobj;
						 int type;
						 qobj = (QObject*)Get_QObject(varg0);
						 type = NUM2INT(varg1);
						 QApplication::sendPostedEvents(qobj,type);
					}
			 }
		}
		
		static void      removePostedEvents( QObject *receiver );

		//virtual 
		bool     notify( QObject *, QEvent * );

		static bool	     startingUp();
		static bool	     closingDown();

		static void	     flushX();
		static void	     syncX();

		static void	     beep();
#ifndef QT_NO_TRANSLATION
		void	     setDefaultCodec( QTextCodec* qtc);
		QTextCodec*	     defaultCodec() const;
		void	     installTranslator( QTranslator * qt );
		void	     removeTranslator( QTranslator * qt);
#endif

		//QString	     translate( const char * scope, const char * key ) const;
		//QString	     translate( const char *, const char *,
		//				const char * ) const;
	 %extend {
			QString translate(const char* scope, const char* key, VALUE varg2=Qnil) const {
				 if(varg2 == Qnil) {
						return self->translate(scope,key);
				 } else {
						char* arg2;
						arg2 = STR2CSTR(varg2);
						return self->translate(scope,key,arg2);
				 }
			}
	 }
				
#ifndef QT_NO_PALETTE
		static void      setWinStyleHighlightColor( const QColor & );
		static const QColor &winStyleHighlightColor();
#endif
		static void      setDesktopSettingsAware( bool );
		static bool      desktopSettingsAware();

		static void      setCursorFlashTime( int );
		static int       cursorFlashTime();

		static void      setDoubleClickInterval( int );
		static int       doubleClickInterval();

		static void      setWheelScrollLines( int );
		static int       wheelScrollLines();

		static void setStartDragTime( int ms );
		static int startDragTime();
		static void setStartDragDistance( int l );
		static int startDragDistance();

#if defined(_WS_MAC_)
		void	     do_mouse_down(void *);
		virtual bool     macEventFilter( MSG * );
		int              macProcessEvent( MSG * );
#elif defined(_WS_WIN_)
		virtual bool     winEventFilter( MSG * );
#elif defined(_WS_X11_)
//    virtual bool     x11EventFilter( XEvent * );
//    virtual int	     x11ClientMessage( QWidget*, XEvent*, bool passive_only);
//    int              x11ProcessEvent( XEvent* );
#elif defined(_WS_QWS_)
		virtual bool     qwsEventFilter( QWSEvent * );
		int              qwsProcessEvent( QWSEvent* );
		void             qwsSetCustomColors( QRgb *colortable, int start, int numColors );
#ifndef QT_NO_QWS_MANAGER
		static QWSDecoration &qwsDecoration();
		static void      qwsSetDecoration( QWSDecoration *);
#endif
#endif

#if defined(_WS_WIN_)
		static WindowsVersion winVersion();
		void	     winFocus( QWidget *, bool );
		static void	     winMouseButtonUp();
#endif

#ifndef QT_NO_SESSIONMANAGER
		// session management
		bool	     isSessionRestored() const;
		QString	     sessionId() const;
//    virtual void     commitData( QSessionManager& sm );
//    virtual void     saveState( QSessionManager& sm );
#endif
#if defined(_WS_X11_)
		static void create_xim();
		static void close_xim();
#endif

		void	     wakeUpGuiThread();

//signals:
//    void	     lastWindowClosed();
//    void	     aboutToQuit();
//    void	     guiThreadAwake();

//public: slots:
		void	     quit();
		void	     closeAllWindows();
//added for convenience for Ruby/Qt2
//bool connect ( const QObject * sender, const char * signal, const char * member ) const;
};

#endif
