=begin
/****************************************************************************
** $Id: richtext.rb,v 1.1.1.1 2002/12/22 14:19:57 taka-hr Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/
=end
#include "richtext.h"

#include <qhbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qtextview.h>
#include <qbrush.h>
#include <qapplication.h>
require "qt2"
include Qt2

class MyRichText < QVBox
def setString( s )
   @sayings = s
   @view.setText( QString::fromLocal8Bit(@sayings[0]) )
end
def initialize( parent, name )
    super( parent, name )

    setMargin( 5 )

    @view = QTextView.new("","", self )
    @view.setText( "This is a <b>Test</b> with <i>italic</i> <u>stuff</u>" )
    @paper = QBrush.new(Qt::black)
    @paper.setPixmap( QPixmap.new( "marble.png" ) )
    @view.setPaper( @paper )

    @view.setMinimumSize( 450, 250 )

    @buttons = QHBox.new( self )
    @buttons.setMargin( 5 )

    @bClose = QPushButton.new( "&Close", @buttons )
    @bPrev = QPushButton.new( "<< &Prev", @buttons )
    @bNext = QPushButton.new( "&Next >>", @buttons )

    @bPrev.setEnabled( FALSE )

    connect( @bClose, QSIGNAL( "clicked()" ), QApplication::qApp, QSLOT( "quit()" ) )
    connect( @bPrev, QSIGNAL( "clicked()" ), self, "prev()" )
    connect( @bNext, QSIGNAL( "clicked()" ), self, "next()" )

    @num = 0
end

def prev()

    if ( @num <= 0 )
        return
    end
    @num -= 1

    @view.setText( QString::fromLocal8Bit(@sayings[@num]) )

    if ( @num == 0 )
        @bPrev.setEnabled( FALSE )
    end
    @bNext.setEnabled( TRUE )
end

def next()

    if ( @num >= @sayings.size()-1 )
        return
    end
    @num += 1

    @view.setText( QString::fromLocal8Bit(@sayings[@num]) )

    if ( @num >= @sayings.size()-1 )
        @bNext.setEnabled( FALSE )
    end
    @bPrev.setEnabled( TRUE )
end

end
