require "qte"
include Qte
require "qpe"
include Qpe
require "qtetable"
include Qtetable

class Table < QTable

def initialize(row, col, parent, name)
   super
   verticalHeader.setLabel(0,"Vertical Header")
   setLeftMargin(100)
   resize(sizeHintCustom) #resize(sizeHint)  #not implemented?
   connect(self,QSIGNAL("valueChanged(int,int)"),self,"printCur")
end

def sizeHintCustom
   w = (numCols + 1) * columnWidth(0) + 5
   h = (numRows + 1) * rowHeight(0) + 5
   QSize.new(w,h)
end

def printAll
   for r in 0..(numRows() - 1)
      for c in 0..(numCols() - 1)
         print text(r,c).to_str+":"
      end
      print "\n"
   end
end

def printCur
print "Changed cell is #{1 + currentRow}:#{1 + currentColumn} = #{text(currentRow, currentColumn).local8Bit.to_str}\n"
end

end

a = QPEApplication.new([$0]+ARGV)
table = Table.new(5,3,nil,"table")

a.showMainWidget(table)

a.exec
