#!/bin/sh

# libqte-ja-build.sh:
#   build the Qt/Embedded library with many national language
#   codecs support
#
# Copyright (C) 2002  YamaKen <yamaken@bp.iij4u.or.jp>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# $Name: LIBQTE_JA_2_3_3_5 $
# $Id: libqte-ja-build.sh,v 1.3 2002/10/11 15:56:54 yamaken Exp $

################################################################
#Rewrite these vars to fit your environment

ARM_CROSSCOMPILE=/opt/Embedix/tools
ARM_QTBINDIR=/opt/Qtopia/sharp
ARM_PLATFORM=linux-sharp-g++
ARM_OPTIONAL_ARG="-depths 16,32 -no-qvfb -gif -system-jpeg -I$ARM_QTBINDIR/include -L$ARM_QTBINDIR/lib"

I386_CROSSCOMPILE=/usr
I386_QTBINDIR=/opt/Qtopia
I386_PLATFORM=linux-x86-g++
I386_OPTIONAL_ARG='-depths v,4,8,16,24,32 -qvfb'

HOST_CROSSCOMPILE=
HOST_QTBINDIR=/opt/Qtopia
HOST_PLATFORM=
HOST_OPTIONAL_ARG='-depths v,4,8,16,24,32 -qvfb'
################################################################

ARCH='host'
PLATFORM_ARG=
LIBQTE_JA_PATCH=`dirname $0`/libqte-ja.patch

################################################################

deref() {
    local VAR=$1; shift

    eval "echo \$$VAR"
}

import_vars() {
    local NAMESPACE=$1; shift
    local VARS=$*
    local VAR VAL

    for VAR in $VARS; do
        VAL=`deref ${NAMESPACE}_${VAR}`
        eval "$VAR='$VAL'"
    done
}

strip_path() {
    local PATHSTR=$1; shift
    local TO_BE_REMOVED=$1; shift
    local STRIPPED

    STRIPPED=`echo $PATHSTR \
              | sed "s!(^|:)$TO_BE_REMOVED(:|$)!!g" | sed 's/::/:/g'`
    echo $STRIPPED

    if [ "$STRIPPED" = "$PATHSTR" ]; then
        return 1
    else
        return 0
    fi
}

prepend_path() {
    local PATHVAR=$1; shift
    local NEWPATH=$1; shift
    local PATHVAL STRIPPED NOT_FOUND=

    PATHVAL=`deref $PATHVAR`
    STRIPPED=`strip_path $PATHVAL $NEWPATH`
    strip_path $PATHVAL $NEWPATH >/dev/null || NOT_FOUND=TRUE

    if [ $NOT_FOUND ]; then
        export $PATHVAR=$NEWPATH:$PATHVAL
    fi
}

################################################################

while [ "$1" ]; do
    OPT="$1"; shift
    case "$OPT" in
        -arch)
            ARCH="$1"; shift
            ;;
    esac
done
ARCH_PREFIX=`perl -e "print uc($ARCH)"`
import_vars $ARCH_PREFIX CROSSCOMPILE QTBINDIR PLATFORM OPTIONAL_ARG

if [ "$ARCH" != 'host' ]; then
    prepend_path PATH $CROSSCOMPILE/bin
    PLATFORM_ARG="-xplatform $PLATFORM"
fi
prepend_path PATH $QTBINDIR/bin
prepend_path LD_LIBRARY_PATH $QTBINDIR/lib

#Build Qt/Embedded
export QTXDIR=$PWD/qt-x11-2.3.2
export QTDIR=$PWD/qt-2.3.3
export QPEDIR=$PWD/qtopia-free-1.5.0
cd $QPEDIR/qt
patch -p0 <$LIBQTE_JA_PATCH
cd $QTDIR
cp $QTBINDIR/bin/moc bin
cp $QPEDIR/qt/qconfig-qpe.h $QTDIR/src/tools
echo yes | ./configure $PLATFORM_ARG -qconfig qpe $OPTIONAL_ARG
make -C src
