/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.jface.ImageResource;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolveStatusPanel
implements SelectablePanel {
    private static final ImageResource QUESTION = new ImageResource(SolveStatusPanel.class, "problem00.png");
    private static final ImageResource CORRECT = new ImageResource(SolveStatusPanel.class, "problem01.png");
    private static final ImageResource QUASI_CORRECT = new ImageResource(SolveStatusPanel.class, "problem02.png");
    private static final ImageResource WRONG = new ImageResource(SolveStatusPanel.class, "problem03.png");
    private static final ImageResource ANSWER = new ImageResource(SolveStatusPanel.class, "problem04.png");
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private final Adapter adapter_ = new Adapter();
    private Label imageLabel_ = null;

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.imageLabel_ = new Label(composite, 2052);
        this.imageLabel_.setImage(QUESTION.get());
        return this.imageLabel_;
    }

    @Override
    public Control getControl() {
        return null;
    }

    @Override
    public void dispose() {
    }

    private class Adapter
    implements EventBrokerMonitor,
    ControllerStatusMonitor,
    ProblemStatusMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            SolveStatusPanel.this.eventBroker_.removeView(SolveStatusPanel.this);
            SolveStatusPanel.this.eventBroker_ = eventBroker;
            SolveStatusPanel.this.eventBroker_.addView(SolveStatusPanel.this);
        }

        public void setEditMode(boolean bl) {
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (handlerPhase.equals(HandlerPhase.SOLVE)) {
                this.updateStatusImpl(QUESTION);
            } else if (handlerPhase.equals(HandlerPhase.ANSWER)) {
                this.updateStatusImpl(ANSWER);
            }
        }

        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull((Object)problemStatus);
            switch (problemStatus) {
                case SOLVE: {
                    this.updateStatusImpl(QUESTION);
                    break;
                }
                case CORRECT: {
                    this.updateStatusImpl(CORRECT);
                    break;
                }
                case ONE_STEP_SHORT: {
                    this.updateStatusImpl(QUASI_CORRECT);
                    break;
                }
                case MISTAKE: {
                    this.updateStatusImpl(WRONG);
                    break;
                }
            }
        }

        private void updateStatusImpl(ImageResource imageResource) {
            SolveStatusPanel.this.imageLabel_.setImage(imageResource.get());
        }
    }
}

