/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.jface.ColorResource;
import org.unitarou.jface.FontResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfNumber;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.swt.USashForm;
import org.unitarou.util.Adaptable;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.events.TieredModelEventNotifier;
import org.unitarou.yukinoshita.model.CollectionEditor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeProblemCommand;
import org.unitarou.yukinoshita.view.cmd.TimeupInProblemCommand;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.jface.gm.NoteMemoPanel;
import org.unitarou.yukinoshita.view.jface.pa.AnswerSelectorPanel;
import org.unitarou.yukinoshita.view.jface.pa.SolveStatusPanel;
import org.unitarou.yukinoshita.view.jface.pa.Timer;
import org.unitarou.yukinoshita.view.jface.util.WidgetFactory;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemActionPanel
implements SelectablePanel {
    private static final Message CLB_ANSWER = new Message(ProblemActionPanel.class, "clbAnswer");
    private static final Message CLB_RETRY = new Message(ProblemActionPanel.class, "clbRetry");
    private static final Message CLB_PREVIOUS = new Message(ProblemActionPanel.class, "clbPrevious");
    private static final Message CLB_NEXT = new Message(ProblemActionPanel.class, "clbNext");
    private static final Message LB_TIME_LEFT = new Message(ProblemActionPanel.class, "lbTimeLeft");
    private static final Message LB_PAUSE_TIMER = new Message(ProblemActionPanel.class, "lbPauseTimer");
    private static final FontResource FONT_TIME_LEFT = new FontResource("Helvetica", 18, 0);
    private static final ColorResource COL_TIME_OK = new ColorResource(6);
    private static final ColorResource COL_TIME_WARN = new ColorResource(8);
    private static final ColorResource COL_TIME_UP = new ColorResource(4);
    private static final ColorResource COL_TIME_DISABLE = new ColorResource(16);
    private Reference<CollectionEditor> refCe_ = new WeakReference<Object>(null);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Control rootControl_ = null;
    private final Adapter adapter_ = new Adapter();
    private final AnswerSelectorPanel answerSelectorPanel_ = new AnswerSelectorPanel();
    private final SolveStatusPanel solveStatusPanel_ = new SolveStatusPanel();
    private Button answer_ = null;
    private Button retry_ = null;
    private Button previous_ = null;
    private Button next_ = null;
    private Label timeLeft_ = null;
    private Button pauseTimer_;
    private final Timer timer_ = new Timer();
    private boolean enableTimer_;
    private final NoteMemoPanel noteMemoPanel_ = new NoteMemoPanel();
    private final SelectablePanel[] adaptables_s_ = new SelectablePanel[]{this.answerSelectorPanel_, this.solveStatusPanel_, this.noteMemoPanel_};

    @Override
    public Control createContents(Composite composite) {
        USashForm uSashForm = WidgetFactory.createUSashForm(composite, 512);
        Composite composite2 = new Composite(uSashForm, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout(gridLayout);
        Control control = this.createButtonFrame(composite2);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        control = this.answerSelectorPanel_.createContents(composite2);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        control = this.solveStatusPanel_.createContents(composite2);
        control.setLayoutData(new GridData(4, 4, true, true));
        control = this.createTimerFrame(composite2);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.noteMemoPanel_.createContents(uSashForm);
        uSashForm.setWeights(new int[]{2, 1});
        this.rootControl_ = uSashForm;
        return this.rootControl_;
    }

    private Control createButtonFrame(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        composite2.setLayout(gridLayout);
        GridData gridData = new GridData(16384, 0x1000000, true, false);
        this.previous_ = new Button(composite2, 8);
        this.previous_.setLayoutData(gridData);
        this.previous_.setText(CLB_PREVIOUS.get());
        this.previous_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeProblemCommand(-1));
            }
        });
        gridData = new GridData(131072, 0x1000000, true, false);
        this.retry_ = new Button(composite2, 8);
        this.retry_.setLayoutData(gridData);
        this.retry_.setText(CLB_RETRY.get());
        this.retry_.setEnabled(false);
        this.retry_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SOLVE));
            }
        });
        gridData = new GridData(16384, 0x1000000, true, false);
        this.next_ = new Button(composite2, 8);
        this.next_.setLayoutData(gridData);
        this.next_.setText(CLB_NEXT.get());
        this.next_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeProblemCommand(1));
            }
        });
        gridData = new GridData(131072, 0x1000000, true, false);
        this.answer_ = new Button(composite2, 8);
        this.answer_.setLayoutData(gridData);
        this.answer_.setText(CLB_ANSWER.get());
        this.answer_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProblemActionPanel.this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.ANSWER));
            }
        });
        return composite2;
    }

    private Control createTimerFrame(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new GridLayout(3, false));
        Label label = new Label(composite2, 0);
        label.setText(LB_TIME_LEFT.get());
        label.setLayoutData(new GridData(131072, 0x1000000, false, true));
        this.timeLeft_ = new Label(composite2, 0);
        this.timeLeft_.setText("");
        this.timeLeft_.setLayoutData(new GridData(4, 0x1000000, true, true));
        this.timeLeft_.setFont(FONT_TIME_LEFT.get());
        this.timer_.addListener(new Timer.TimerListener(){

            public void countDown() {
                ProblemActionPanel.this.countDown();
            }

            public void timeup() {
                ProblemActionPanel.this.timeup();
            }
        });
        this.pauseTimer_ = new Button(composite2, 2);
        this.pauseTimer_.setSelection(false);
        this.pauseTimer_.setText(LB_PAUSE_TIMER.get());
        this.pauseTimer_.setLayoutData(new GridData(131072, 0x1000000, false, true));
        this.pauseTimer_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ProblemActionPanel.this.pauseTimer_.getSelection()) {
                    ProblemActionPanel.this.timer_.pause();
                } else {
                    ProblemActionPanel.this.timer_.restart();
                }
            }
        });
        return composite2;
    }

    @Override
    public void dispose() {
        this.timer_.stop();
        for (SelectablePanel selectablePanel : this.adaptables_s_) {
            selectablePanel.dispose();
        }
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.rootControl_;
    }

    private void start() {
        this.timeLeft_.setText(String.valueOf(this.timer_.timeLimit()));
        if (this.enableTimer_) {
            this.timer_.start();
        }
        this.updateFontColor();
    }

    private void countDown() {
        if (!this.timeLeft_.isDisposed()) {
            this.timeLeft_.setText(String.valueOf(this.timer_.timeLeft()));
            this.updateFontColor();
        }
    }

    private void timeup() {
        if (!this.timeLeft_.isDisposed()) {
            this.timer_.stop();
            this.updateFontColor();
            this.eventBroker_.executeCommand(new TimeupInProblemCommand());
        }
    }

    private void updateFontColor() {
        if (!this.enableTimer_) {
            this.timeLeft_.setForeground(COL_TIME_DISABLE.get());
        } else if (10 < this.timer_.timeLeft()) {
            this.timeLeft_.setForeground(COL_TIME_OK.get());
        } else if (0 < this.timer_.timeLeft()) {
            this.timeLeft_.setForeground(COL_TIME_WARN.get());
        } else {
            this.timeLeft_.setForeground(COL_TIME_UP.get());
        }
    }

    private void updateProblemProperties() {
        ProblemProperties problemProperties = this.getCurrentContextPp();
        this.retry_.setVisible(problemProperties.contains(ProblemProperties.Flag.RETRYABLE));
        this.enableTimer_ = problemProperties.contains(ProblemProperties.Flag.TIME_LIMIT) && this.timer_.timeLimit() != 0;
        this.pauseTimer_.setEnabled(this.enableTimer_);
        if (!this.enableTimer_) {
            this.timer_.stop();
        }
    }

    private ProblemProperties getCurrentContextPp() {
        CollectionEditor collectionEditor = this.refCe_.get();
        Collection collection = collectionEditor != null ? collectionEditor.getCollection() : null;
        CurrentContext currentContext = Yukinoshita.context(collection);
        Object object = currentContext.getAttribute(Context.PROBLEM_PROPERTIES);
        if (!(object instanceof ProblemProperties)) {
            object = Context.PROBLEM_PROPERTIES.defaultValue();
        }
        return (ProblemProperties)object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    extends TieredModelEventNotifier
    implements EventBrokerMonitor,
    CollectionMonitor,
    GameMonitor,
    ControllerStatusMonitor,
    ProblemStatusMonitor,
    ContextMonitor {
        private Adapter() {
        }

        @Override
        protected Adaptable[] getAdaptables() {
            return ProblemActionPanel.this.adaptables_s_;
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            ProblemActionPanel.this.eventBroker_.removeView(ProblemActionPanel.this);
            ProblemActionPanel.this.eventBroker_ = eventBroker;
            ProblemActionPanel.this.eventBroker_.addView(ProblemActionPanel.this);
            super.setEventBroker(eventBroker);
        }

        @Override
        public void update(CollectionEditor collectionEditor) {
            ProblemActionPanel.this.refCe_ = new WeakReference<CollectionEditor>(collectionEditor);
            ProblemActionPanel.this.updateProblemProperties();
        }

        @Override
        public void update(GameMediator gameMediator) {
            CollectionEditor collectionEditor = (CollectionEditor)ProblemActionPanel.this.refCe_.get();
            if (collectionEditor == null) {
                ProblemActionPanel.this.next_.setEnabled(false);
            }
            ProblemActionPanel.this.next_.setEnabled(collectionEditor.getActiveGameIndex() != collectionEditor.size() - 1);
            int n = collectionEditor.getActiveGameIndex();
            ProblemActionPanel.this.previous_.setEnabled(!collectionEditor.isDrill() && 1 <= n || 2 <= n);
            String string = BasicFinder.findDatum(gameMediator.getRootGameTree().getSequence(), SgfId.TIMELIMIT);
            SgfNumber sgfNumber = SgfNumber.parseQuietly(string);
            if (sgfNumber != null) {
                ProblemActionPanel.this.timer_.setTimeLimit(sgfNumber.getIntValue());
            }
            ProblemActionPanel.this.updateProblemProperties();
            ProblemActionPanel.this.start();
        }

        @Override
        public void setEditMode(boolean bl) {
            if (bl) {
                return;
            }
            CollectionEditor collectionEditor = (CollectionEditor)ProblemActionPanel.this.refCe_.get();
            if (collectionEditor == null) {
                return;
            }
            Collection collection = collectionEditor.getCollection();
            if (collection.size() == 0) {
                return;
            }
            RootGameTree rootGameTree = collection.get(0);
            if (!rootGameTree.getGameType().equals(GameType.DRILL)) {
                return;
            }
            String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES);
            ProblemProperties problemProperties = ProblemProperties.parsePpQuietly(string);
            ProblemProperties problemProperties2 = ProblemActionPanel.this.getCurrentContextPp();
            if (problemProperties == null || problemProperties2.equals(problemProperties)) {
                return;
            }
            Yukinoshita.context(collection).setAttribute(Context.PROBLEM_PROPERTIES.id(), problemProperties);
            Yukinoshita.context().fireAttributeChanged(new String[]{Context.PROBLEM_PROPERTIES.id()});
            ProblemActionPanel.this.start();
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (handlerPhase.equals(HandlerPhase.SOLVE)) {
                this.updateStatusImpl(true, false);
                ProblemActionPanel.this.pauseTimer_.setSelection(false);
                if (ProblemActionPanel.this.enableTimer_) {
                    ProblemActionPanel.this.start();
                }
            } else if (handlerPhase.equals(HandlerPhase.ANSWER)) {
                this.updateStatusImpl(false, true);
                ProblemActionPanel.this.timer_.stop();
            }
        }

        @Override
        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull((Object)problemStatus);
            switch (problemStatus) {
                case SOLVE: {
                    this.updateStatusImpl(true, false);
                    break;
                }
                case MISTAKE: 
                case CORRECT: 
                case ONE_STEP_SHORT: {
                    this.updateStatusImpl(true, true);
                    ProblemActionPanel.this.timer_.stop();
                    break;
                }
                default: {
                    this.updateStatusImpl(false, true);
                }
            }
        }

        private void updateStatusImpl(boolean bl, boolean bl2) {
            ProblemActionPanel.this.answer_.setEnabled(bl);
            ProblemActionPanel.this.retry_.setEnabled(bl2);
        }

        @Override
        public void attributeChanged(Set<String> set) {
            ArgumentChecker.throwIfNull(set);
            if (set.contains(Context.PROBLEM_PROPERTIES.id())) {
                ProblemActionPanel.this.updateProblemProperties();
            }
        }
    }
}

