/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.ml.Message;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.GameMediator;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.sound.SoundEffect;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.cmd.NodeSelectionCommand;
import org.unitarou.yukinoshita.view.jface.SelectablePanel;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnswerSelectorPanel
implements SelectablePanel {
    private static final Message LB_SOLUTION = new Message(AnswerSelectorPanel.class, "lbSolution");
    private static final Message LB_PROBLEM = new Message(AnswerSelectorPanel.class, "lbProblem");
    private static final Message LB_CORRECT = new Message(AnswerSelectorPanel.class, "lbCorrect");
    private static final Message LB_ONE_STEP_SHORT = new Message(AnswerSelectorPanel.class, "lbOneStepShort");
    private static final Message LB_MISTAKE = new Message(AnswerSelectorPanel.class, "lbMistake");
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private Reference<NodeList> refNodeList_ = new WeakReference<Object>(null);
    private final Adapter adapter_ = new Adapter();
    private Composite frame_ = null;
    private Combo combo_ = null;
    private final List<Answer> answers_ = new ArrayList<Answer>(1);
    private boolean isEditMode_ = false;

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(new GridLayout(2, false));
        Label label = new Label(this.frame_, 0);
        label.setText(LB_SOLUTION.get());
        label.setLayoutData(new GridData(131072, 0x1000000, false, false));
        this.combo_ = new Combo(this.frame_, 12);
        this.combo_.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.combo_.setEnabled(false);
        this.combo_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AnswerSelectorPanel.this.showAnswer();
            }
        });
        return this.frame_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showAnswer() {
        if (this.isEditMode_) {
            return;
        }
        NodeList nodeList = this.refNodeList_.get();
        if (nodeList == null) {
            return;
        }
        assert (this.eventBroker_ != EventBroker.NULL_BROKER);
        boolean bl = SoundEffect.isMute();
        SoundEffect.setMute(true);
        try {
            this.resetVariation(nodeList);
            int n = this.combo_.getSelectionIndex();
            if (n == 0) {
                return;
            }
            Answer answer = this.answers_.get(n - 1);
            for (Integer n2 : answer.tracks_) {
                NodeView[] nodeViewArray = nodeList.getCurrentNodeView().getVariations();
                while (nodeViewArray.length == 0) {
                    this.eventBroker_.executeCommand(new NodeJumpCommand(1));
                    nodeViewArray = nodeList.getCurrentNodeView().getVariations();
                }
                int n3 = n2;
                assert (n3 < nodeViewArray.length);
                this.eventBroker_.executeCommand(new SelectVariation(n3));
                this.eventBroker_.executeCommand(new NodeJumpCommand(1));
            }
            this.eventBroker_.executeCommand(new NodeSelectionCommand(nodeList.size() - 1));
        }
        finally {
            SoundEffect.setMute(bl);
        }
    }

    private void resetVariation(NodeList nodeList) {
        for (int i = 0; i < nodeList.size(); ++i) {
            NodeView nodeView = nodeList.getNodeView(i);
            if (!nodeView.containsPropertyType(PropertyType.SETUP)) continue;
            this.eventBroker_.executeCommand(new NodeSelectionCommand(i));
            return;
        }
    }

    private void updateAllVariation(RootGameTree rootGameTree) {
        this.answers_.clear();
        SgfColor sgfColor = BasicFinder.firstMove(rootGameTree);
        if (sgfColor == null) {
            return;
        }
        SgfId sgfId = sgfColor == SgfColor.BLACK ? SgfId.GOOD_FOR_BLACK : SgfId.GOOD_FOR_WHITE;
        this.updateAllVariationImpl(rootGameTree, sgfId, new Answer());
        Collections.sort(this.answers_, new Comparator<Answer>(){

            @Override
            public int compare(Answer answer, Answer answer2) {
                return answer.status_.compareTo(answer2.status_);
            }
        });
        this.combo_.add(LB_PROBLEM.get());
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        block5: for (Answer answer : this.answers_) {
            switch (answer.status_) {
                case CORRECT: {
                    this.combo_.add(LB_CORRECT.get((Object)new Integer(n)));
                    ++n;
                    continue block5;
                }
                case ONE_STEP_SHORT: {
                    this.combo_.add(LB_ONE_STEP_SHORT.get((Object)new Integer(n2)));
                    ++n2;
                    continue block5;
                }
                case MISTAKE: {
                    this.combo_.add(LB_MISTAKE.get((Object)new Integer(n3)));
                    ++n3;
                    continue block5;
                }
            }
            assert (false) : Answer.access$400(answer);
        }
    }

    private void updateAllVariationImpl(GameTree gameTree, SgfId sgfId, Answer answer) {
        String string = BasicFinder.findDatum(gameTree.getSequence(), sgfId);
        SgfDouble sgfDouble = SgfDouble.parseQuietly(string);
        if (SgfDouble.NORMAL.equals(sgfDouble)) {
            answer.status_ = ProblemStatus.ONE_STEP_SHORT;
        } else if (SgfDouble.EMPHASIZED.equals(sgfDouble)) {
            answer.status_ = ProblemStatus.CORRECT;
        }
        GameTree[] gameTreeArray = gameTree.getChildren();
        if (gameTreeArray.length == 0) {
            boolean bl = true;
            for (Integer n : answer.tracks_) {
                if (n == 0) continue;
                bl = false;
                break;
            }
            if (bl) {
                answer.status_ = ProblemStatus.CORRECT;
            }
            this.answers_.add(answer);
            return;
        }
        for (int i = 0; i < gameTreeArray.length; ++i) {
            Answer answer2 = new Answer(answer);
            answer2.tracks_.add(new Integer(i));
            this.updateAllVariationImpl(gameTreeArray[i], sgfId, answer2);
        }
    }

    @Override
    public void dispose() {
    }

    private class Adapter
    implements EventBrokerMonitor,
    GameMonitor,
    ControllerStatusMonitor {
        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            AnswerSelectorPanel.this.eventBroker_.removeView(AnswerSelectorPanel.this);
            AnswerSelectorPanel.this.eventBroker_ = eventBroker;
            AnswerSelectorPanel.this.eventBroker_.addView(AnswerSelectorPanel.this);
        }

        public void update(GameMediator gameMediator) {
            ArgumentChecker.throwIfNull((Object)gameMediator);
            AnswerSelectorPanel.this.refNodeList_ = new WeakReference<NodeList>(gameMediator.getNodeList());
            AnswerSelectorPanel.this.combo_.removeAll();
            if (gameMediator.getGameType() != GameType.PROBLEM) {
                return;
            }
            AnswerSelectorPanel.this.updateAllVariation(gameMediator.getRootGameTree());
        }

        public void setEditMode(boolean bl) {
            AnswerSelectorPanel.this.isEditMode_ = bl;
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            boolean bl = HandlerPhase.ANSWER.equals(handlerPhase);
            AnswerSelectorPanel.this.combo_.setEnabled(bl);
            if (bl) {
                AnswerSelectorPanel.this.combo_.forceFocus();
                AnswerSelectorPanel.this.combo_.select(0);
                AnswerSelectorPanel.this.showAnswer();
            }
        }
    }

    private static class Answer {
        private ProblemStatus status_;
        private final List<Integer> tracks_;

        private Answer() {
            this.status_ = ProblemStatus.MISTAKE;
            this.tracks_ = new ArrayList<Integer>(1);
        }

        private Answer(Answer answer) {
            this.status_ = answer.status_;
            this.tracks_ = new ArrayList<Integer>(answer.tracks_);
        }
    }
}

