/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.unitarou.jface.ColorResource;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.view.jface.board.IgoOutlinePanel;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

public class FilesOutlinePanel
implements WidgetContainer {
    private static final Log log_s_ = LogFactory.getLog(FilesOutlinePanel.class);
    private final Message NT_LOADING_POSITION = new Message(FilesOutlinePanel.class, "ntLoadingPosition");
    private final ColorResource[] COL_BKS = new ColorResource[]{new ColorResource(22)};
    private ScrolledComposite scrolledComposite_;
    private Composite frame_;
    private GridLayout gridLayout_;
    private List<IgoOutlinePanel> list_;

    public FilesOutlinePanel(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Bad size of column: " + n);
        }
        this.scrolledComposite_ = null;
        this.frame_ = null;
        this.gridLayout_ = new GridLayout(n, false);
        this.gridLayout_.verticalSpacing = 0;
        this.gridLayout_.horizontalSpacing = 0;
        this.list_ = new ArrayList<IgoOutlinePanel>();
    }

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.scrolledComposite_ = new ScrolledComposite(composite, 512);
        this.scrolledComposite_.setLayout(new FillLayout());
        this.scrolledComposite_.setExpandHorizontal(true);
        this.scrolledComposite_.setExpandVertical(false);
        this.scrolledComposite_.addControlListener(new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                FilesOutlinePanel.this.resized();
            }
        });
        this.frame_ = new Composite(this.scrolledComposite_, 0);
        this.scrolledComposite_.setContent(this.frame_);
        return this.scrolledComposite_;
    }

    public void dispose() {
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.dispose();
        }
    }

    public Control getControl() {
        return this.scrolledComposite_;
    }

    private void resized() {
        Point point = Geometry.getSize(this.scrolledComposite_.getClientArea());
        this.scrolledComposite_.setMinSize(point);
        int n = point.x / this.gridLayout_.numColumns - (this.gridLayout_.horizontalSpacing * 2 + this.frame_.getBorderWidth());
        ScrollBar scrollBar = this.scrolledComposite_.getVerticalBar();
        scrollBar.setIncrement(n / 2);
        int n2 = point.y / n;
        scrollBar.setPageIncrement(n2 * n);
        point.x = n;
        point.y = n;
        for (IgoOutlinePanel igoOutlinePanel : this.list_) {
            igoOutlinePanel.setBoardSize(point);
        }
        this.frame_.pack();
    }

    public void setFiles(File[] fileArray) {
        ArgumentChecker.throwIfNull((Object)fileArray);
        StopWatch stopWatch = new StopWatch();
        this.frame_.dispose();
        for (IgoOutlinePanel object : this.list_) {
            object.dispose();
        }
        this.list_.clear();
        this.frame_ = new Composite(this.scrolledComposite_, 0);
        this.frame_.setLayout(this.gridLayout_);
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            Collection collection = CollectionRepository.instance().load(file);
            if (collection.size() < 5) {
                this.load(collection, i);
                continue;
            }
            try {
                new ProgressMonitorDialog(this.frame_.getShell()).run(true, true, new RunnableImpl(collection));
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.scrolledComposite_.setContent(this.frame_);
        this.resized();
        this.scrolledComposite_.setMinSize(this.frame_.getSize());
        if (log_s_.isTraceEnabled()) {
            log_s_.trace("Total costs: " + stopWatch.stopSecond() + " [secs]");
        }
    }

    private void load(Collection collection, int n) {
        for (int i = 0; i < collection.size(); ++i) {
            RootGameTree rootGameTree = collection.get(i);
            IgoOutlinePanel igoOutlinePanel = new IgoOutlinePanel(this.COL_BKS[(i + n) % this.COL_BKS.length].get());
            Control control = igoOutlinePanel.createContents(this.frame_);
            GridData gridData = new GridData(4, 4, true, true);
            control.setLayoutData(gridData);
            igoOutlinePanel.setRootGameTree(rootGameTree);
            this.list_.add(igoOutlinePanel);
        }
    }

    private class RunnableImpl
    implements IRunnableWithProgress {
        private Collection collection_;

        private RunnableImpl(Collection collection) {
            this.collection_ = collection;
        }

        public void run(final IProgressMonitor iProgressMonitor) {
            iProgressMonitor.beginTask(FilesOutlinePanel.this.NT_LOADING_POSITION.get(), this.collection_.size());
            int n = 0;
            while (n < this.collection_.size()) {
                final RootGameTree rootGameTree = this.collection_.get(n);
                final int n2 = n++;
                FilesOutlinePanel.this.frame_.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        iProgressMonitor.subTask(RootGameTreeLabelProvider.CONTEXT.defaultProvider().getLabel(rootGameTree));
                        IgoOutlinePanel igoOutlinePanel = new IgoOutlinePanel(FilesOutlinePanel.this.COL_BKS[n2 % FilesOutlinePanel.this.COL_BKS.length].get());
                        Control control = igoOutlinePanel.createContents(FilesOutlinePanel.this.frame_);
                        GridData gridData = new GridData(4, 4, true, true);
                        control.setLayoutData(gridData);
                        igoOutlinePanel.setRootGameTree(rootGameTree);
                        FilesOutlinePanel.this.list_.add(igoOutlinePanel);
                    }
                });
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) break;
            }
            iProgressMonitor.done();
        }
    }
}

