/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.KeyEvent;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.LearnEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SelectEventDelegator;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameViewStateHandler
extends CanvasHookedStateHandler {
    private static final Log log_s_ = LogFactory.getLog(GameViewStateHandler.class);
    private final Adapter adapter_;

    public GameViewStateHandler(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);
        ArgumentChecker.throwIfNull((Object)igoBoardPanel);
        this.registerDelegator(HandlerPhase.SELECT, new SelectEventDelegator());
        this.registerDelegator(HandlerPhase.LEARN, new LearnEventDelegator());
        this.setEventDelegator(HandlerPhase.SELECT);
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    protected void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        this.changeVariation(n);
        NodeList nodeList = this.getIgoBoardPanel().getNodeView().getNodeList();
        EventBroker eventBroker = this.getEventBroker();
        ViewerUtils.handleSelectNode(n, nodeList, eventBroker);
        switch (n) {
            case 0x1000002: {
                if (this.getHandlerPhase().equals(HandlerPhase.LEARN)) break;
                eventBroker.executeCommand(new NodeJumpCommand(1));
                break;
            }
            case 0x1000001: {
                eventBroker.executeCommand(new NodeJumpCommand(-1));
            }
        }
    }

    @Override
    protected void mouseWheel(int n) {
        if (this.getHandlerPhase().equals(HandlerPhase.LEARN) && 0 < (n /= 3)) {
            return;
        }
        if (n != 0) {
            NodeJumpCommand nodeJumpCommand = new NodeJumpCommand(n);
            this.getEventBroker().executeCommand(nodeJumpCommand);
        }
    }

    private class Adapter
    implements ControllerStatusMonitor {
        private HandlerPhase currentHandlerPhase_;

        private Adapter() {
        }

        public void setEditMode(boolean bl) {
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (handlerPhase.equals(this.currentHandlerPhase_)) {
                return;
            }
            if (GameViewStateHandler.this.findDelegator(handlerPhase) == null) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SELECT + " insted. status=" + handlerPhase);
                handlerPhase = HandlerPhase.SELECT;
            }
            GameViewStateHandler.this.setEventDelegator(handlerPhase);
            GameViewStateHandler.this.getEventDelegator().resetStatus();
            BlockSituation blockSituation = GameViewStateHandler.this.getEventDelegator().getBlockSituation(GameViewStateHandler.this.getIgoBoardPanel().getNodeView(), GameViewStateHandler.this.getBlockStatus(), GameViewStateHandler.this.getMouseEvent());
            GameViewStateHandler.this.getIgoBoardPanel().getCanvas().setCursor(blockSituation.getCursor());
            this.currentHandlerPhase_ = handlerPhase;
        }
    }
}

