/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import java.util.Map;
import java.util.SortedMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.lang.Strings;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.board.IgoBoard;
import org.unitarou.yukinoshita.model.board.IgoBoardView;
import org.unitarou.yukinoshita.model.board.TextViewer;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;

public class IgoTextBoardPanel
implements IgoBoardPanel {
    private final IgoBoard igoBoard_ = new IgoBoard(SgfSize.DEFAULT);
    private final Composite parent_;
    private final Label control_;

    public IgoTextBoardPanel(Composite composite) {
        this.parent_ = composite;
        this.control_ = new Label(this.parent_, 2052);
        FontData fontData = new FontData("\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 20, 0);
        Font font = new Font((Device)this.parent_.getDisplay(), fontData);
        this.control_.setFont(font);
        this.draw();
    }

    private int boardLength() {
        return this.igoBoard_.size().height() * (this.igoBoard_.size().width() + 1);
    }

    public void update(NodeView nodeView) {
        if (nodeView == null) {
            throw new NullArgumentException();
        }
        IgoBoardView igoBoardView = nodeView.getIgoBoard();
        if (!this.igoBoard_.size().equals(igoBoardView.size())) {
            this.igoBoard_.setSize(igoBoardView.size());
        }
        this.updateModel(igoBoardView);
        this.draw();
    }

    private void updateModel(IgoBoardView igoBoardView) {
        SortedMap<SgfPoint, SgfColor> sortedMap = igoBoardView.diff(this.igoBoard_);
        for (Map.Entry<SgfPoint, SgfColor> entry : sortedMap.entrySet()) {
            SgfPoint sgfPoint = entry.getKey();
            SgfColor sgfColor = entry.getValue();
            this.igoBoard_.removeStone(sgfPoint);
            if (sgfColor == null) continue;
            this.igoBoard_.setStone(new Stone(sgfColor, sgfPoint, null));
        }
        this.igoBoard_.setCaptured(igoBoardView.getCaptured());
    }

    private void draw() {
        StringBuilder stringBuilder = new StringBuilder(this.boardLength());
        TextViewer textViewer = new TextViewer();
        String[] stringArray = textViewer.write(this.igoBoard_);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append(Strings.LINE_SEPARATOR);
        }
        stringBuilder.append(textViewer.getCharacter(SgfPointType.BLACK));
        stringBuilder.append(this.igoBoard_.getCaptured(SgfColor.BLACK).size());
        stringBuilder.append(" ");
        stringBuilder.append(textViewer.getCharacter(SgfPointType.WHITE));
        stringBuilder.append(this.igoBoard_.getCaptured(SgfColor.WHITE).size());
        this.control_.setText(stringBuilder.toString());
    }

    public void setEditMode(boolean bl) {
    }

    public Control createContents(Composite composite) {
        return null;
    }

    public void dispose() {
    }

    public Canvas getCanvas() {
        return null;
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public BlockStatus getBlockStatus(Point point) {
        return null;
    }

    public NodeView getNodeView() {
        return null;
    }

    public void paintInTransient(Property property) {
    }

    public void setContext(CurrentContext currentContext) {
    }
}

