/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.sound;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.sound.NullClip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SoundEffect
extends Enum<SoundEffect> {
    public static final /* enum */ SoundEffect MOVE = new SoundEffect("move.wav");
    public static final /* enum */ SoundEffect CORRECT = new SoundEffect("correct.wav");
    public static final /* enum */ SoundEffect ONE_STEP_SHORT = new SoundEffect("oneStepShort.wav");
    public static final /* enum */ SoundEffect MISTAKE = new SoundEffect("mistake.wav");
    private static final Log log_s_;
    private static boolean isMute_s_;
    private static final ContextListener listener_s_;
    private final String resourceName_;
    private final List<File> files_;
    private int index_;
    private Clip clip_;
    private static final /* synthetic */ SoundEffect[] $VALUES;

    public static final SoundEffect[] values() {
        return (SoundEffect[])$VALUES.clone();
    }

    public static SoundEffect valueOf(String string) {
        return Enum.valueOf(SoundEffect.class, string);
    }

    private static void updateMuteStatus() {
        CurrentContext currentContext = Yukinoshita.context().getCurrent(null);
        SoundEffect.setMute(!currentContext.getBoolean(Context.ENABLE_SOUND_EFFECT));
    }

    public static boolean isMute() {
        return isMute_s_;
    }

    public static void setMute(boolean bl) {
        for (SoundEffect soundEffect : SoundEffect.values()) {
            BooleanControl booleanControl = (BooleanControl)soundEffect.clip_.getControl(BooleanControl.Type.MUTE);
            if (booleanControl == null) {
                log_s_.warn("Can't find Mute control at " + (Object)((Object)soundEffect));
                continue;
            }
            booleanControl.setValue(bl);
        }
        isMute_s_ = bl;
    }

    private SoundEffect(String string2) {
        assert (string2 != null);
        this.resourceName_ = string2;
        this.files_ = new ArrayList<File>(1);
        this.index_ = -1;
        this.clip_ = NullClip.instance();
        this.createClip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClip() {
        InputStream inputStream = null;
        try {
            inputStream = this.index_ == -1 ? SoundEffect.class.getResourceAsStream(this.resourceName_) : new FileInputStream(this.files_.get(this.index_));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log_s_.error(fileNotFoundException.getLocalizedMessage());
        }
        if (inputStream == null) {
            log_s_.warn("Can't get inputstream: " + (this.index_ < 0 ? this.resourceName_ : (Serializable)this.files_.get(this.index_)));
            return;
        }
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            this.clip_.close();
            this.clip_ = (Clip)AudioSystem.getLine(info);
            this.clip_.open(audioInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            log_s_.warn(unsupportedAudioFileException.getLocalizedMessage());
            this.clip_ = NullClip.instance();
        }
        catch (IOException iOException) {
            log_s_.warn(iOException.getLocalizedMessage());
            this.clip_ = NullClip.instance();
        }
        catch (LineUnavailableException lineUnavailableException) {
            log_s_.warn(lineUnavailableException.getLocalizedMessage());
            this.clip_ = NullClip.instance();
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public boolean register(File file) throws IOException {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.canRead()) {
            throw new IOException("Can't read file:" + file);
        }
        if (this.files_.contains(file)) {
            return false;
        }
        this.files_.add(file);
        return true;
    }

    public void setIndex(int n) {
        if (n < -1 || this.files_.size() <= n) {
            throw new IllegalArgumentException("index is out of range: " + n);
        }
        this.index_ = n;
        this.createClip();
    }

    public Clip getClip() {
        return this.clip_;
    }

    public File[] getRegistered() {
        return this.files_.toArray(new File[this.files_.size()]);
    }

    public void play() {
        if (this.clip_.isRunning()) {
            this.clip_.flush();
        }
        this.clip_.setFramePosition(0);
        this.clip_.start();
    }

    static {
        $VALUES = new SoundEffect[]{MOVE, CORRECT, ONE_STEP_SHORT, MISTAKE};
        log_s_ = LogFactory.getLog(SoundEffect.class);
        isMute_s_ = true;
        listener_s_ = new ContextListener(){

            @Override
            public void attributeChanged(Set<String> set) {
                if (set.contains(Context.ENABLE_SOUND_EFFECT.id())) {
                    SoundEffect.updateMuteStatus();
                }
            }
        };
        Context context = Yukinoshita.context();
        context.addListener(listener_s_);
        SoundEffect.updateMuteStatus();
    }
}

