/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.cmd;

import java.util.EnumSet;
import java.util.LinkedList;
import org.unitarou.cmd.AbstractCommand;
import org.unitarou.cmd.Command;
import org.unitarou.ml.Message;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.model.NodeEntity;
import org.unitarou.yukinoshita.model.NodeListEditor;
import org.unitarou.yukinoshita.model.cmd.Command4NodeList;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.sound.SoundEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectVariation
extends Command4NodeList {
    private static final Message LB_NAME = new Message(SelectVariation.class, "lbName");
    private final int newVariationIndex_;
    private NodeEntity targetNode_;
    private int targetPosition_;
    private int lastIndex_;
    private LinkedList<NodeEntity> removedChain_;
    private Command commandImpl_;
    private final boolean playSound_;

    public SelectVariation(int n) {
        this(n, false);
    }

    public SelectVariation(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("newIndex must not be negative number: newIndex = " + n);
        }
        this.newVariationIndex_ = n;
        this.targetPosition_ = -1;
        this.commandImpl_ = null;
        this.removedChain_ = null;
        this.playSound_ = bl;
    }

    @Override
    protected boolean setup() {
        if (0 <= this.targetPosition_) {
            return true;
        }
        NodeListEditor nodeListEditor = this.getEditableNodeList();
        if (nodeListEditor == null) {
            return false;
        }
        this.targetPosition_ = nodeListEditor.getPositionIndex();
        this.setDisplayName(LB_NAME.get());
        this.setExecutedNodeIndex(nodeListEditor.getPositionIndex());
        this.setUndoneNodeIndex(nodeListEditor.getPositionIndex());
        return true;
    }

    @Override
    public void execute() {
        super.execute();
        this.targetNode_ = this.getEditableNodeList().get(this.targetPosition_);
        if (this.newVariationIndex_ < 0 || this.targetNode_.getNodeTree().getVariationSize() <= this.newVariationIndex_) {
            throw new IndexOutOfBoundsException("A new index is " + this.newVariationIndex_ + " but target.size is " + this.targetNode_.getNodeTree().getVariationSize() + ".");
        }
        this.lastIndex_ = this.targetNode_.getSelectedVariationIndex();
        this.commandImpl_ = this.targetNode_.getNodeTree().isChildrenStyle() ? new SelectVariationAsChildren() : new SelectVariationAsSibling();
        if (this.newVariationIndex_ == this.lastIndex_) {
            return;
        }
        this.commandImpl_.execute();
    }

    @Override
    public void undo() {
        super.undo();
        if (this.newVariationIndex_ == this.lastIndex_) {
            return;
        }
        this.commandImpl_.undo();
    }

    @Override
    public EnumSet<ModelInfluence> getInfluence() {
        return EnumSet.of(ModelInfluence.NODE_CURRENT);
    }

    private class SelectVariationAsSibling
    extends AbstractCommand {
        private NodeEntity unchangedLastNode_;

        public void execute() {
            int n;
            assert (!SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) : "Children style must not user this class.";
            super.execute();
            SelectVariation.this.removedChain_ = new LinkedList();
            NodeEntity nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            while (!nodeEntity.equals(SelectVariation.this.targetNode_)) {
                SelectVariation.this.removedChain_.addFirst(nodeEntity);
                if (SelectVariation.this.getEditableNodeList().size() == 0) break;
                nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            }
            this.unchangedLastNode_ = (n = SelectVariation.this.getEditableNodeList().size()) != 0 ? SelectVariation.this.getEditableNodeList().getLast() : null;
            GameTree gameTree = SelectVariation.this.targetNode_.getNodeTree().getParentGameTree();
            SelectVariation.this.getEditableNodeList().addLast(gameTree.getChild(SelectVariation.this.newVariationIndex_));
            SelectVariation.this.getEditableNodeList().get(n).setSelectedVariationIndex(SelectVariation.this.newVariationIndex_);
            SgfPoint sgfPoint = SelectVariation.this.getEditableNodeList().get(n).getMove().getPoint();
            if (SelectVariation.this.playSound_ && sgfPoint != null && SgfPointType.IN.equals((Object)sgfPoint.condition())) {
                SoundEffect.MOVE.play();
            }
        }

        public void undo() {
            assert (!SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) : "Children style must not user this class.";
            super.undo();
            NodeEntity nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            while (!nodeEntity.equals(this.unchangedLastNode_) && SelectVariation.this.getEditableNodeList().size() != 0) {
                nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            }
            if (this.unchangedLastNode_ != null) {
                SelectVariation.this.getEditableNodeList().addLast(this.unchangedLastNode_);
            }
            SelectVariation.this.targetNode_.setSelectedVariationIndex(SelectVariation.this.lastIndex_);
            SelectVariation.this.getEditableNodeList().addLast(SelectVariation.this.targetNode_);
            SelectVariation.this.getEditableNodeList().addLast(SelectVariation.this.removedChain_.toArray(new NodeEntity[SelectVariation.this.removedChain_.size()]));
            SelectVariation.this.removedChain_ = null;
            this.unchangedLastNode_ = null;
        }
    }

    private class SelectVariationAsChildren
    extends AbstractCommand {
        public void execute() {
            assert (SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) : "Sibling style must not user this class.";
            super.execute();
            SelectVariation.this.removedChain_ = new LinkedList();
            NodeEntity nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            while (!nodeEntity.equals(SelectVariation.this.targetNode_)) {
                SelectVariation.this.removedChain_.addFirst(nodeEntity);
                nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            }
            SelectVariation.this.getEditableNodeList().addLast(nodeEntity);
            SelectVariation.this.targetNode_.setSelectedVariationIndex(SelectVariation.this.newVariationIndex_);
            GameTree gameTree = SelectVariation.this.targetNode_.getNodeTree().getGameTree();
            SelectVariation.this.getEditableNodeList().addLast(gameTree.getChild(SelectVariation.this.newVariationIndex_));
        }

        public void undo() {
            assert (SelectVariation.this.targetNode_.getNodeTree().isChildrenStyle()) : "Sibling style must not user this class.";
            super.undo();
            SelectVariation.this.targetNode_.setSelectedVariationIndex(SelectVariation.this.lastIndex_);
            NodeEntity nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            while (!nodeEntity.equals(SelectVariation.this.targetNode_)) {
                nodeEntity = SelectVariation.this.getEditableNodeList().removeLast();
            }
            SelectVariation.this.getEditableNodeList().addLast(nodeEntity);
            SelectVariation.this.getEditableNodeList().addLast(SelectVariation.this.removedChain_.toArray(new NodeEntity[SelectVariation.this.removedChain_.size()]));
            SelectVariation.this.removedChain_ = null;
        }
    }
}

