/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.Runtimes;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.io.dl.DefaultHttpDownloader;
import org.unitarou.sgf.io.dl.HttpDownloader;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;
import org.unitarou.yukinoshita.view.provider.vlp.NoVariationProvider;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

public class Yukinoshita {
    private static final String PROPERTIES_FILE_NAME = "." + File.separator + "yukinoshita.properties";
    private static final Log log_s_ = LogFactory.getLog(Yukinoshita.class);
    private static final Message NT_FILE_READ_ERROR = new Message(Yukinoshita.class, "ntFileReadError");
    private static final Message MSG_PROPERTIES_FILE_NOT_FOUND = new Message(Yukinoshita.class, "msgPropertiesFileNotFound");
    private static final Message MSG_PROPERTIES_READ_ERROR = new Message(Yukinoshita.class, "msgPropertiesReadError");
    private static final Message NT_BAD_PARAMETER_IN_PROPERTIES = new Message(Yukinoshita.class, "ntBadParameterInProperties");
    private static final Message MSG_BAD_APPLICATION_CLASS_NAME = new Message(Yukinoshita.class, "msgBadApplicationClassName");
    private static final Message MSG_BAD_DEFAULT_CHARSET = new Message(Yukinoshita.class, "msgBadDefaultCharset");
    private static final Message MSG_BAD_PROVIDER_CLASS_NAME = new Message(Yukinoshita.class, "msgBadProviderClassName");
    private static final Message MSG_BAD_ARGUMENT_FILE_NOT_FOUND = new Message(Yukinoshita.class, "msgBadArgumentFileNotFound");
    private static final String PROP_KEY_APPLICATION = "application";
    private static final String PROP_DEF_APPLICATION = "org.unitarou.yukinoshita.view.jface.JFaceApplication";
    private static final String PROP_KEY_DEFAULT_CHARSET = "defaultCharset";
    private static final String PROP_KEY_PREFIX_PROVIDER = "provider.";
    private static final Message NT_MEMORY_IS_EXHAUSTED = new Message(Yukinoshita.class, "ntMemoryIsExhausted");
    private static final Message MSG_MEMORY_IS_EXHAUSTED = new Message(Yukinoshita.class, "msgMemoryIsExhausted");
    private static final long FREEMEMORY_4_OPEN_FILE = 0x400000L;
    public static final String USER_NAME = System.getProperty("user.name", "yukinoshita");
    private static Yukinoshita yukinoshita_s_;
    private final Properties properties_ = this.readProperties();
    private Application application_ = this.loadApplication();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            yukinoshita_s_ = new Yukinoshita();
            File[] fileArray = Yukinoshita.paresFile(stringArray);
            yukinoshita_s_.start(fileArray);
            Messages.inspectUnusedMessages();
        }
        catch (Throwable throwable) {
            log_s_.fatal("Uncaught exception error.", throwable);
        }
        finally {
            if (yukinoshita_s_ != null) {
                yukinoshita_s_.dispose();
            }
        }
    }

    private static File[] paresFile(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        for (String string : stringArray) {
            File file = new File(string);
            if (file.exists() && file.isFile()) {
                arrayList.add(file);
                continue;
            }
            log_s_.info(MSG_BAD_ARGUMENT_FILE_NOT_FOUND.get((Object)string));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static Yukinoshita instance() {
        return yukinoshita_s_;
    }

    public static Application application() {
        return Yukinoshita.yukinoshita_s_.application_;
    }

    public static Context context() {
        return Yukinoshita.yukinoshita_s_.application_.getContext();
    }

    public static CurrentContext context(Object object) {
        return Yukinoshita.yukinoshita_s_.application_.getContext().getCurrent(object);
    }

    public static void callDebugInitializer() {
        if (yukinoshita_s_ != null) {
            return;
        }
        yukinoshita_s_ = new Yukinoshita();
        yukinoshita_s_.setupProvider();
        yukinoshita_s_.setupCharset();
        Yukinoshita.yukinoshita_s_.application_.getContext().load();
    }

    private Yukinoshita() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties readProperties() {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(PROPERTIES_FILE_NAME);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log_s_.warn("Properties file is not found.", fileNotFoundException);
            JOptionPane.showMessageDialog(null, MSG_PROPERTIES_FILE_NOT_FOUND.get((Object)PROPERTIES_FILE_NAME), NT_FILE_READ_ERROR.get(), 2);
            IOUtils.closeQuietly(fileInputStream);
        }
        catch (IOException iOException) {
            log_s_.warn("Failure to read properties file.", iOException);
            JOptionPane.showMessageDialog(null, MSG_PROPERTIES_READ_ERROR.get((Object)PROPERTIES_FILE_NAME), NT_FILE_READ_ERROR.get(), 2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fileInputStream);
        }
        IOUtils.closeQuietly(fileInputStream);
        return properties;
    }

    private Application loadApplication() {
        String string = this.properties_.getProperty(PROP_KEY_APPLICATION, PROP_DEF_APPLICATION);
        try {
            Class<?> clazz = Class.forName(string);
            return (Application)clazz.newInstance();
        }
        catch (Exception exception) {
            log_s_.warn("Failure to create an application instance.", exception);
            JOptionPane.showMessageDialog(null, MSG_BAD_APPLICATION_CLASS_NAME.get(PROP_KEY_APPLICATION, string, PROP_DEF_APPLICATION), NT_BAD_PARAMETER_IN_PROPERTIES.get(), 2);
            try {
                return (Application)Class.forName(PROP_DEF_APPLICATION).newInstance();
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception2);
            }
        }
    }

    private void start(File[] fileArray) {
        this.setupProvider();
        this.setupCharset();
        this.application_.getContext().load();
        this.application_.start(fileArray);
    }

    private void setupProvider() {
        Context context = this.application_.getContext();
        context.registerInterface(CoordinatesLabelProvider.class);
        context.registerInterface(VariationLabelProvider.class);
        context.registerInterface(BlockLabelProvider.class);
        context.registerInterface(RootGameTreeLabelProvider.class);
        context.registerInterface(HttpDownloader.class);
        context.registerProvider(CoordinatesLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(VariationLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(BlockLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(RootGameTreeLabelProvider.CONTEXT.defaultProvider().getClass());
        context.registerProvider(DefaultHttpDownloader.class);
        context.registerProvider(NoVariationProvider.class);
        for (Map.Entry<Object, Object> entry : this.properties_.entrySet()) {
            String string = entry.getKey().toString();
            String string2 = entry.getValue().toString();
            try {
                if (!string.startsWith(PROP_KEY_PREFIX_PROVIDER)) continue;
                context.registerProvider(Class.forName(string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                log_s_.warn("Failure to set provider class.", classNotFoundException);
                this.application_.openMessageDialog(Application.MessageLevel.WARNING, NT_BAD_PARAMETER_IN_PROPERTIES.get(), MSG_BAD_PROVIDER_CLASS_NAME.get(string, string2));
            }
        }
    }

    private void setupCharset() {
        CurrentContext currentContext = Yukinoshita.context(null);
        Collection<Charset> collection = Charset.availableCharsets().values();
        currentContext.setAttribute(Context.KEY_CHARSETS, collection.toArray(new Charset[collection.size()]));
        Charset charset = Charset.forName("UTF-8");
        String string = this.properties_.getProperty(PROP_KEY_DEFAULT_CHARSET);
        try {
            charset = Charset.forName(string);
        }
        catch (Exception exception) {
            log_s_.warn("Failure to get default charset.", exception);
            this.application_.openMessageDialog(Application.MessageLevel.WARNING, NT_BAD_PARAMETER_IN_PROPERTIES.get(), MSG_BAD_DEFAULT_CHARSET.get(PROP_KEY_DEFAULT_CHARSET, Strings.nullToNullMark(string), charset.name()));
        }
        currentContext.setAttribute(Context.KEY_DEFAULT_CHARSET, charset);
    }

    private void dispose() {
        this.application_.dispose();
    }

    public String getName() {
        return "Yukinoshita";
    }

    public String getVersion() {
        return "2.0.2";
    }

    public String getLastUpdate() {
        return "2006/01/22";
    }

    public boolean checkFreeMemory() {
        int n;
        for (n = 0; Runtimes.availableMemory() < 0x400000L && n < 6; ++n) {
            System.gc();
        }
        if (n == 6) {
            this.application_.openMessageDialog(Application.MessageLevel.WARNING, NT_MEMORY_IS_EXHAUSTED.get(), MSG_MEMORY_IS_EXHAUSTED.get());
            return false;
        }
        return true;
    }
}

