/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.io.CollectionRepository;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.context.Context;

public final class FileManager {
    private static final Log log_s_ = LogFactory.getLog(FileManager.class);
    private static final Message MSG_FILE_IO_ERROR = new Message(FileManager.class, "msgFileIoError");
    private static final Message MSG_FILE_OPEN_ERROR = new Message(FileManager.class, "msgFileOpenError");
    private static final Message MSG_ERROR_ON_WRITE = new Message(FileManager.class, "msgErrorOnWrite");
    private static final Message NT_FILE_READ_FAILURE = new Message(FileManager.class, "ntFileReadFailure");
    private static final Message MSG_GAME_NOT_FOUND = new Message(FileManager.class, "msgGameNotFound");
    private static final Message NT_CANT_OVERWRITE = new Message(FileManager.class, "ntCantOverwrite");
    private static final Message MSG_READ_ONLY_FILE = new Message(FileManager.class, "msgReadOnlyFile");
    private static final Message MSG_ALREADY_UPDATED = new Message(FileManager.class, "msgAlreadyUpdated");
    private static final File trashCan_s_ = new File("./trushCan.sgf");
    private static final FileManager instance_s_ = new FileManager();
    private final Map<File, Collection> fileMap_ = new HashMap<File, Collection>();

    public static FileManager instance() {
        return instance_s_;
    }

    private FileManager() {
    }

    public Collection open(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        Collection collection = this.openImpl(file);
        if (collection.size() != 0) {
            return collection;
        }
        String string = MSG_GAME_NOT_FOUND.get((Object)file);
        log_s_.info(string);
        Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_FILE_READ_FAILURE.get(), string);
        return null;
    }

    private Collection openImpl(File file) {
        String string;
        ProblemProperties problemProperties;
        ArgumentChecker.throwIfNull((Object)file);
        Collection collection = this.fileMap_.get(file);
        if (collection != null) {
            return collection;
        }
        collection = CollectionRepository.instance().load(file);
        if (collection.size() == 0) {
            return collection;
        }
        RootGameTree rootGameTree = collection.get(0);
        if (GameType.DRILL.equals(rootGameTree.getGameType()) && (problemProperties = ProblemProperties.parsePpQuietly(string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES))) != null) {
            Yukinoshita.context(collection).setAttribute(Context.PROBLEM_PROPERTIES.id(), problemProperties);
        }
        return collection;
    }

    public void close(Collection collection) {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() != null) {
            this.fileMap_.remove(collection.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Collection collection) throws YukinoshitaException {
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.getFile() == null) {
            throw new IllegalArgumentException("collection.getFile() must not be null.");
        }
        try {
            if (!GameType.DRILL.equals(collection.get(0).getGameType())) {
                this.saveImpl(collection);
            } else {
                Collection collection2 = new Collection(collection);
                while (1 < collection2.size()) {
                    collection2.remove(1);
                }
                this.saveImpl(collection2);
            }
        }
        finally {
            collection.setFile(collection.getFile());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveImpl(Collection collection) throws YukinoshitaException {
        SgfFormatter sgfFormatter = new SgfFormatter();
        FileOutputStream fileOutputStream = null;
        try {
            ByteBuffer byteBuffer = sgfFormatter.format(collection);
            fileOutputStream = new FileOutputStream(collection.getFile());
            fileOutputStream.getChannel().write(byteBuffer);
            fileOutputStream.flush();
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                throw new YukinoshitaException(MSG_ERROR_ON_WRITE.get((Object)fileNotFoundException.getLocalizedMessage()), fileNotFoundException);
                catch (IOException iOException) {
                    throw new YukinoshitaException(MSG_FILE_IO_ERROR.get((Object)iOException.getLocalizedMessage()), iOException);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(fileOutputStream);
    }

    public boolean checkOverwritable(Collection collection) {
        File file = collection.getFile();
        if (file == null) {
            return false;
        }
        FileSnapshot fileSnapshot = new FileSnapshot(file);
        FileSnapshot fileSnapshot2 = collection.getFileSnapshot();
        if (fileSnapshot.equals(fileSnapshot2) && file.canWrite()) {
            return true;
        }
        String string = !file.canWrite() ? MSG_READ_ONLY_FILE.get((Object)file.getAbsolutePath()) : MSG_ALREADY_UPDATED.get(file.getAbsolutePath(), new Date(fileSnapshot2.lastModified()), new Long(fileSnapshot2.length()), new Date(fileSnapshot.lastModified()), new Long(fileSnapshot.length()));
        Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, NT_CANT_OVERWRITE.get(), string);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(RootGameTree rootGameTree) {
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            collection.addLast(rootGameTree);
            this.save(collection);
        }
        catch (YukinoshitaException yukinoshitaException) {
            yukinoshitaException.printStackTrace();
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RootGameTree pickUp(int n) {
        RootGameTree rootGameTree = null;
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            if (n < 0 || collection.size() <= n) {
                throw new IllegalArgumentException("Bad index (out of range):" + n);
            }
            rootGameTree = collection.remove(n);
            this.save(collection);
            RootGameTree rootGameTree2 = rootGameTree;
            return rootGameTree2;
        }
        catch (YukinoshitaException yukinoshitaException) {
            yukinoshitaException.printStackTrace();
            RootGameTree rootGameTree3 = rootGameTree;
            return rootGameTree3;
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getTrashCan() {
        Collection collection = null;
        try {
            collection = this.openTrashCan();
            Collection collection2 = new Collection(collection);
            return collection2;
        }
        finally {
            if (collection != null) {
                this.close(collection);
            }
        }
    }

    public void clearTrashCan() {
        trashCan_s_.delete();
    }

    private Collection openTrashCan() {
        if (!trashCan_s_.exists()) {
            Collection collection = new Collection();
            collection.setFile(trashCan_s_);
            return collection;
        }
        return this.openImpl(trashCan_s_);
    }
}

