/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.util;

import java.util.Collection;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFormatter {
    public static String format(Collection<SgfPoint> collection) {
        if (collection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (SgfPoint sgfPoint : collection) {
            stringBuilder.append('[');
            stringBuilder.append(sgfPoint.x()).append(',').append(sgfPoint.y());
            stringBuilder.append(']');
        }
        if (!collection.isEmpty()) {
            stringBuilder.append(collection.iterator().next().size().toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static CharSequence pickOutToSgf(Sequence sequence, SgfId ... sgfIdArray) {
        ArgumentChecker.throwIfNull((Object)sequence, (Object)sgfIdArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : sequence) {
            boolean bl = false;
            int n = stringBuilder.length();
            for (SgfId sgfId : sgfIdArray) {
                Property property = node.getProperty(sgfId);
                if (property == null) continue;
                stringBuilder.append(property.toSgf());
                bl = true;
            }
            if (!bl) continue;
            stringBuilder.insert(n, ';');
        }
        return stringBuilder;
    }

    protected BasicFormatter() {
    }
}

