/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Provider;

public class ProviderCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(ProviderCodec.class);
    private static final ProviderCodec instance_s_ = new ProviderCodec();

    public static ProviderCodec instance() {
        return instance_s_;
    }

    private ProviderCodec() {
    }

    public boolean isEncodable(Class clazz) {
        return Provider.class.isAssignableFrom(clazz);
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object.getClass())) {
            throw new IllegalArgumentException();
        }
        return this.encode((Provider)object);
    }

    public String encode(Provider provider) {
        return provider.getClass().getName();
    }

    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        try {
            Class<?> clazz = Class.forName(string);
            if (Provider.class.isAssignableFrom(clazz)) {
                return clazz.newInstance();
            }
        }
        catch (Exception exception) {
            log_s_.warn("[IGNORE] " + string + " by " + exception.getLocalizedMessage());
            return null;
        }
        return null;
    }
}

