/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.unitarou.jface.pref.PreferenceArrayCodec;
import org.unitarou.util.ArgumentChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileArrayCodec
implements PreferenceArrayCodec<File> {
    private static FileArrayCodec instance_s_ = new FileArrayCodec();

    public static FileArrayCodec instance() {
        return instance_s_;
    }

    private FileArrayCodec() {
    }

    @Override
    public boolean isEncodable(Class clazz) {
        File[] fileArray = new File[]{};
        return List.class.isAssignableFrom(clazz) || fileArray.getClass().isAssignableFrom(clazz);
    }

    @Override
    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (object instanceof File[]) {
            return this.encode((File[])object);
        }
        if (!this.isEncodable(object.getClass())) {
            throw new IllegalArgumentException();
        }
        for (Object e : (List)object) {
            if (e instanceof File) continue;
            throw new IllegalArgumentException();
        }
        return this.encode((List)object);
    }

    public String encode(File[] fileArray) {
        ArgumentChecker.throwIfNull((Object)fileArray);
        return this.encode(Arrays.asList(fileArray));
    }

    @Override
    public String encode(List<File> list) {
        ArgumentChecker.throwIfNull(list);
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : list) {
            stringBuilder.append(file.getAbsolutePath()).append(File.pathSeparatorChar);
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<File> decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        ArrayList<File> arrayList = new ArrayList<File>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new File(stringTokenizer.nextToken()));
        }
        return arrayList;
    }
}

