/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import java.io.FileFilter;
import java.text.Collator;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.unitarou.io.Ios;
import org.unitarou.jface.FileAnnotationLabelProvider;
import org.unitarou.jface.FileFolderListener;
import org.unitarou.jface.FileListContentProvider;
import org.unitarou.ml.Message;
import org.unitarou.swt.WidgetContainer;
import org.unitarou.util.ArgumentChecker;

public class FilesTableViewer
implements WidgetContainer {
    private static final Message LB_FILENAME = new Message(FilesTableViewer.class, "lbFilename");
    private File folder_;
    private final int tvFlag_;
    private TableViewer tableViewer_;
    private FileFilter fileFilter_;
    private final Set<FileFolderListener> listeners_;

    public FilesTableViewer() {
        this(67588);
    }

    public FilesTableViewer(int n) {
        this.tvFlag_ = n;
        this.folder_ = Ios.getCurrentDirectory();
        this.tableViewer_ = null;
        this.fileFilter_ = TrueFileFilter.INSTANCE;
        this.listeners_ = new HashSet<FileFolderListener>();
    }

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.tableViewer_ = new TableViewer(composite, this.tvFlag_);
        Table table = this.tableViewer_.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(LB_FILENAME.get());
        tableColumn.setWidth(200);
        this.tableViewer_.setContentProvider(new FileListContentProvider());
        this.tableViewer_.setLabelProvider(new FileAnnotationLabelProvider());
        this.tableViewer_.addFilter(new ViewerFilterImpl());
        this.tableViewer_.setSorter(new ViewerSorterImpl());
        this.tableViewer_.setInput(this.folder_);
        TableViewersListener tableViewersListener = new TableViewersListener();
        this.tableViewer_.addPostSelectionChangedListener(tableViewersListener);
        this.tableViewer_.addDoubleClickListener(tableViewersListener);
        return this.tableViewer_.getControl();
    }

    public void dispose() {
    }

    public File getFolder() {
        return this.folder_;
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Parameter 'folder' must be a directory: " + file.getPath());
        }
        this.folder_ = file;
        if (this.tableViewer_ != null) {
            this.tableViewer_.setInput(this.folder_);
        }
    }

    public void setFileFilter(FileFilter fileFilter) {
        ArgumentChecker.throwIfNull((Object)fileFilter);
        this.fileFilter_ = fileFilter;
        this.tableViewer_.refresh();
    }

    public void addListener(FileFolderListener fileFolderListener) {
        if (fileFolderListener == null) {
            return;
        }
        this.listeners_.add(fileFolderListener);
    }

    public void removeListener(FileFolderListener fileFolderListener) {
        this.listeners_.remove(fileFolderListener);
    }

    private class ViewerSorterImpl
    extends ViewerSorter {
        public ViewerSorterImpl() {
        }

        public ViewerSorterImpl(Collator collator) {
            super(collator);
        }

        public int category(Object object) {
            if (object instanceof File) {
                File file = (File)object;
                return file.isDirectory() ? 0 : 1;
            }
            return super.category(object);
        }
    }

    private class ViewerFilterImpl
    extends ViewerFilter {
        private ViewerFilterImpl() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof File) {
                File file = (File)object2;
                return (file.isDirectory() || FilesTableViewer.this.fileFilter_.accept(file)) && !file.isHidden();
            }
            return false;
        }
    }

    private class TableViewersListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private TableViewersListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            Object[] objectArray = ((IStructuredSelection)selectionChangedEvent.getSelection()).toArray();
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            File[] fileArray = new File[objectArray.length];
            System.arraycopy(objectArray, 0, fileArray, 0, fileArray.length);
            for (FileFolderListener fileFolderListener : FilesTableViewer.this.listeners_) {
                fileFolderListener.filesFocused(fileArray);
            }
        }

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            File file = (File)((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement();
            if (file.isDirectory()) {
                for (FileFolderListener fileFolderListener : FilesTableViewer.this.listeners_) {
                    fileFolderListener.folderChanged(file);
                }
                FilesTableViewer.this.folder_ = file;
                return;
            }
            for (FileFolderListener fileFolderListener : FilesTableViewer.this.listeners_) {
                fileFolderListener.filesDoubleClicked(file);
            }
        }
    }
}

