<?php
/**
 * 顼ơ֥ɽ饹
 * 
 * color.inc class Color
 * $Id: color.inc,v 1.1.1.1 2003/01/09 11:20:57 nanasess Exp $
 *
 * @package Yuichat-p
 * @version $Revision: 1.1.1.1 $
 * @author Kentaro Ohkouchi <nanasess@fsm.ne.jp>
 */
class Color
{
    // {{{ propaties

    var $db_name = "myDB_Sql";
    var $include_path = ".";

    // }}}
    // {{{ constructor

    function Color()
    {
    }

    /**
     * 顼ơ֥̾
     * @var string $ColorTableName
     */
    var $ColorTableName = "color";

    /**
     *ϥǡå
     *
     * @return bool
     * @params string $data    Color Code
     */
    function checkData($data)
    {
        if (preg_match("/^[#a-zA-Z0-9]+$/", $data) == false) {
            die("Data Error!");
        }
        return true;
    }

    /**
     * 顼
     *
     * @return string    SQL
     * @params string $where    WHERE
     */
    function getColorQuery($where = "")
    {
        $select = sprintf("SELECT * FROM %s %s", $this->ColorTableName, $where);
        return $select;
    }

    /**
     * ̤˳Ǽ
     *
     * @return array    顼͡[顼]
     */
    function intoColorArray() {
        $select = $this->GetColorQuery();
        $db = new $this->db_name;
        $result = $db->dbObj->getAll($select, DB_FETCHMODE_ASSOC);
        if (DB::isError($result)) {
            $db->dbObj->query("ROLLBACK");
            die($result->getMessage());
        }
        return $result;
    }
  
    /**
     * 顼ꥹȼ
     *
     * @return string    ʸΥꥹȥ˥塼
     * @params array $colorList    顼ꥹȤ
     */
    function getColorList($colorList) {
        $list = "";
        foreach ($colorList as $val) {
                if ($_SESSION["bgcolor"] == $val["color_hex"] || $_SESSION["text_color"] == $val["color_hex"]) {
                    $selected = "selected=\"selected\"";
                } else {
                    $selected = "";
                }
                $list .= sprintf("<option value=\"%s\" style=\"color: %s\" %s>%s</option>\n",
                                 htmlspecialchars($val["color_hex"], ENT_QUOTES), 
                                 htmlspecialchars($val["color_hex"], ENT_QUOTES),
                                 $selected, 
                                 htmlspecialchars($val["color_name"], ENT_QUOTES));
        }
        return $list;
    }
  
    /**
     * 顼ơ֥
     *
     * @return string    顼ơ֥
     * @params array $colorList    顼ꥹȤ
     */
    function getColorTable($colorList) {
        $list = "";
        $count = count($colorList);
        $i = 0;
        $nKey = array();
        $nVal = array();
        foreach ($colorList as $val) {
            $i++;
            $nKey[$i] = $val["color_name"];
            $nVal[$i] = $val["color_hex"];
        }
        $rows = (int)($count / 3); // Կ
        $div = $count % 3;
        if ($div > 0) {
            $rows += 1;
        }
        $l = 0;
        $list = "";
        for ($j=0; $j < $rows; $j++) {
            $list .= "<tr>\n";
          
            for ($k=0; $k < 3; $k++) {
                $l++;
                if (isset($_GET["Type"]) && $_GET["Type"] == "text") {
                    $list .= sprintf("<td><font color=\"%s\">%s</font></td>\n",
                                     htmlspecialchars($nVal[$l], ENT_QUOTES),
                                     htmlspecialchars($nKey[$l], ENT_QUOTES));
                } else {
                    $list .= sprintf("<td align=\"center\" bgcolor=\"%s\">%s</td>\n",
                                     htmlspecialchars($nVal[$l], ENT_QUOTES), 
                                     htmlspecialchars($nKey[$l], ENT_QUOTES));
                }
            }
          
            $list .= "</tr>\n";
        }
        return $list;
    }
  
    /**
     * ƥȥ顼
     * 
     * @return void    ߤΥƥȥ顼
     */
    function getTextColor()
    {
        if ($_SESSION["text_color"] == "") {
            print("#000099");
        } else {
            print(htmlspecialchars($_SESSION["text_color"], ENT_QUOTES));
        }
    }

    /**
     * طʥ顼
     *
     * @return void   ߤطʿ
     */
    function getBgColor()
    {
        if ($_SESSION["bgcolor"] == "") {
            print("#CCFFCC");
        } else {
            print(htmlspecialchars($_SESSION["bgcolor"], ENT_QUOTES));
        }
    }

    /**
     * ǡ򥻥å
     *
     * @return bool
     */
    function postToSession()
    {
        if (isset($_POST["color2"]) && $_POST["color2"] != "") {
            $color = $_POST["color2"];
        } else {
            $color = isset($_POST["color"]) ? $_POST["color"] : "";
        }
        $_SESSION["bgcolor"] = "";
        $_SESSION["text_color"] = "";
        if (isset($_GET["Type"]) && $_GET["Type"] == "text") {
            $_SESSION["bgcolor"] = $color;
        } else {
            $_SESSION["text_color"] = $color;
        }
        return true;
    }

    /**
     * طʿ
     *
     * @return bool
     * @params string $bgColor
     */
    function SelectBgColor($bgColor) {
        $_SESSION["bgcolor"] = "#" . $bgColor;
        return true;
    }

    /**
     * ʸ
     *
     * @return bool
     * @params string $textColor
     */
    function SelectTextColor($textColor) {
        $_SESSION["text_color"] = "#" . $textColor;
        return true;
    }
}
?>