/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import yt4droid.HtmlEntity;
import yt4droid.YoutubeException;
import yt4droid.internal.org.json.JSONArray;
import yt4droid.internal.org.json.JSONException;
import yt4droid.internal.org.json.JSONObject;

public class ParseUtil {
    private static ThreadLocal<Map<String, SimpleDateFormat>> formatMap = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };

    public static String getUnescapedString(String str, JSONObject json) {
        return HtmlEntity.unescape(ParseUtil.getRawString(str, json));
    }

    public static String[] getStringArray(String name, JSONObject json) {
        block4: {
            if (!json.isNull(name)) break block4;
            return null;
        }
        try {
            JSONArray array = json.getJSONArray(name);
            String[] stringArray = new String[array.length()];
            int i = 0;
            while (stringArray.length > i) {
                stringArray[i] = array.getString(i);
                ++i;
            }
            return stringArray;
        }
        catch (JSONException jsone) {
            return null;
        }
    }

    public static String[] getArrangement(String name, JSONObject json) {
        block3: {
            try {
                if (!json.isNull(name)) break block3;
                return null;
            }
            catch (JSONException jsone) {
                return null;
            }
        }
        String splitCom = json.getString(name);
        return splitCom.split(",");
    }

    public static String getRawString(String name, JSONObject json) {
        block3: {
            try {
                if (!json.isNull(name)) break block3;
                return null;
            }
            catch (JSONException jsone) {
                return null;
            }
        }
        return json.getString(name);
    }

    public static String getURLDecodedString(String name, JSONObject json) {
        String returnValue = ParseUtil.getRawString(name, json);
        if (returnValue != null) {
            try {
                returnValue = URLDecoder.decode(returnValue, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return returnValue;
    }

    public static Date parseDate(String asOfStr) throws YoutubeException {
        Date parsed;
        switch (asOfStr.length()) {
            case 10: {
                parsed = new Date(Long.parseLong(asOfStr) * 1000L);
                break;
            }
            case 14: {
                parsed = ParseUtil.getDate(asOfStr, "'T'HH:mm:ss.SSS");
                break;
            }
            case 20: {
                parsed = ParseUtil.getDate(asOfStr, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                break;
            }
            case 24: {
                String parseString = String.valueOf(asOfStr.substring(0, 19)) + "Z";
                parsed = ParseUtil.getDate(parseString, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                break;
            }
            case 29: {
                String parseStringTZD = asOfStr.substring(0, 23);
                parsed = ParseUtil.getDate(parseStringTZD, "yyyy-MM-dd'T'HH:mm:ss.SSS");
                break;
            }
            default: {
                String parseDefault = null;
                if (asOfStr.length() > 19) {
                    parseDefault = String.valueOf(asOfStr.substring(0, 19)) + "Z";
                    parsed = ParseUtil.getDate(parseDefault, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                    break;
                }
                parsed = ParseUtil.getDate(asOfStr, "EEE, d MMM yyyy HH:mm:ss z");
            }
        }
        return parsed;
    }

    public static Date parse(String input) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        if (input.endsWith("Z")) {
            input = String.valueOf(input.substring(0, input.length() - 1)) + "GMT-00:00";
        } else {
            int inset = 6;
            String s0 = input.substring(0, input.length() - inset);
            String s1 = input.substring(input.length() - inset, input.length());
            input = String.valueOf(s0) + "GMT" + s1;
        }
        return df.parse(input);
    }

    public static String toString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
        TimeZone tz = TimeZone.getTimeZone("UTC");
        df.setTimeZone(tz);
        String output = df.format(date);
        int inset0 = 9;
        int inset1 = 6;
        String s0 = output.substring(0, output.length() - inset0);
        String s1 = output.substring(output.length() - inset1, output.length());
        String result = String.valueOf(s0) + s1;
        result = result.replaceAll("UTC", "+00:00");
        return result;
    }

    public static Date getDate(String name, JSONObject json) throws YoutubeException {
        return ParseUtil.getDate(name, json, "EEE MMM d HH:mm:ss z yyyy");
    }

    public static Date getDate(String name, JSONObject json, String format) throws YoutubeException {
        String dateStr = ParseUtil.getUnescapedString(name, json);
        if ("null".equals(dateStr) || dateStr == null) {
            return null;
        }
        return ParseUtil.getDate(dateStr, format);
    }

    public static Date getDate(String name, String format) throws YoutubeException {
        SimpleDateFormat sdf = formatMap.get().get(format);
        if (sdf == null) {
            sdf = new SimpleDateFormat(format, Locale.ENGLISH);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            formatMap.get().put(format, sdf);
        }
        try {
            return sdf.parse(name);
        }
        catch (ParseException pe) {
            throw new YoutubeException("Unexpected date format(" + name + ") returned.", pe);
        }
    }

    public static int getInt(String name, JSONObject json) {
        return ParseUtil.getInt(ParseUtil.getRawString(name, json));
    }

    public static int getInt(String str) {
        if (str == null || "".equals(str) || "null".equals(str)) {
            return -1;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public static long getLong(String name, JSONObject json) {
        return ParseUtil.getLong(ParseUtil.getRawString(name, json));
    }

    public static long getLong(String str) {
        if (str == null || "".equals(str) || "null".equals(str)) {
            return -1L;
        }
        if (str.endsWith("+")) {
            str = str.substring(0, str.length() - 1);
            return Long.valueOf(str) + 1L;
        }
        return Long.valueOf(str);
    }

    public static double getDouble(String name, JSONObject json) {
        String str2 = ParseUtil.getRawString(name, json);
        if (str2 == null || "".equals(str2) || "null".equals(str2)) {
            return -1.0;
        }
        return Double.valueOf(str2);
    }

    public static float getFloat(String name, JSONObject json) {
        String str = ParseUtil.getRawString(name, json);
        if (str == null || "".equals(str) || "null".equals(str)) {
            return -1.0f;
        }
        return Float.valueOf(str).floatValue();
    }

    public static boolean getBoolean(String name, JSONObject json) {
        String str = ParseUtil.getRawString(name, json);
        if (str == null || "null".equals(str)) {
            return false;
        }
        return Boolean.valueOf(str);
    }
}

