/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.parser;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import yt4droid.StatisticsEntity;
import yt4droid.StatisticsEntityImpl;
import yt4droid.UserProfile;
import yt4droid.YoutubeException;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpResponse;
import yt4droid.internal.xml.XMLParseHandler;
import yt4droid.util.ParseUtil;

public class UserProfileParser
implements UserProfile {
    private String id;
    private Date published;
    private Date updated;
    private String title;
    private String name;
    private String uri;
    private String age;
    private String gender;
    private String location;
    private StatisticsEntity statisticsEntity;
    private String thumbnail;
    private String userName;

    protected UserProfileParser(Map entryMap) throws YoutubeException {
        this.init(entryMap);
    }

    private void init(Map entryMap) throws YoutubeException {
        this.id = (String)entryMap.get("id");
        this.published = ParseUtil.parseDate((String)entryMap.get("published"));
        this.updated = ParseUtil.parseDate((String)entryMap.get("updated"));
        this.title = (String)entryMap.get("yt:title");
        Map authorMap = (Map)entryMap.get("author");
        this.name = (String)authorMap.get("name");
        this.uri = (String)authorMap.get("uri");
        this.age = (String)entryMap.get("yt:age");
        this.gender = (String)entryMap.get("yt:gender");
        this.location = (String)entryMap.get("yt:location");
        StatisticsEntityImpl statisticsEntity = new StatisticsEntityImpl((List)entryMap.get("yt:statistics"));
        this.statisticsEntity = statisticsEntity;
        List thumbList = (List)entryMap.get("media:thumbnail");
        if (thumbList != null) {
            Map thumbUrlMap = (Map)thumbList.get(0);
            this.thumbnail = (String)thumbUrlMap.get("url");
        }
        this.userName = (String)entryMap.get("yt:username");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getPublished() {
        return this.published;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getAge() {
        return this.age;
    }

    @Override
    public String getGender() {
        return this.gender;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public StatisticsEntity getStatics() {
        return this.statisticsEntity;
    }

    @Override
    public String getThumbnail() {
        return this.thumbnail;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public static UserProfile createUserProfile(HttpResponse res, Configuration conf) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XMLParseHandler handler = new XMLParseHandler(new HashMap());
            parser.parse(res.asStream(), (DefaultHandler)handler);
            Map map = handler.getDataBean();
            List entry = (List)map.get("entry");
            Map entryMap = null;
            if (entry != null) {
                int i = 0;
                while (entry.size() > 0) {
                    entryMap = (Map)entry.get(i);
                    if (entryMap.get("id") == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                throw new YoutubeException("No data Responsed by Youtube.");
            }
            return new UserProfileParser(entryMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

