/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.parser;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import yt4droid.Comments;
import yt4droid.ResponseList;
import yt4droid.ResponseListImpl;
import yt4droid.YoutubeException;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpResponse;
import yt4droid.internal.xml.XMLParseHandler;
import yt4droid.util.ParseUtil;

public class CommentParser
implements Comments {
    private String id;
    private Date published;
    private Date updated;
    private String title;
    private String content;
    private List<Map<String, List<Map<String, String>>>> link;
    private String name;

    protected CommentParser(Map contentMap) throws YoutubeException {
        this.init(contentMap);
    }

    private void init(Map contentMap) throws YoutubeException {
        String tempId = (String)contentMap.get("id");
        String[] parseArray = tempId.split(":");
        int i = 0;
        while (i < parseArray.length) {
            String ids = parseArray[i];
            if (ids.equals("comment")) {
                this.id = parseArray[i + 1];
                break;
            }
            ++i;
        }
        try {
            this.published = ParseUtil.parseDate((String)contentMap.get("published"));
        }
        catch (YoutubeException ye) {
            ye.printStackTrace();
        }
        try {
            this.updated = ParseUtil.parseDate((String)contentMap.get("updated"));
        }
        catch (YoutubeException ye) {
            ye.printStackTrace();
        }
        this.title = (String)contentMap.get("title");
        this.content = (String)contentMap.get("content");
        this.link = (List)contentMap.get("link");
        Map authorMap = (Map)contentMap.get("author");
        if (authorMap != null) {
            this.name = (String)authorMap.get("name");
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Date getPublished() {
        return this.published;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public List<Map<String, List<Map<String, String>>>> getLink() {
        return this.link;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static ResponseList<Comments> createCommentsList(HttpResponse res, Configuration conf) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            XMLParseHandler handler = new XMLParseHandler(new HashMap());
            parser.parse(res.asStream(), (DefaultHandler)handler);
            Map map = handler.getDataBean();
            List feedList = (List)map.get("feed");
            Map feedMap = null;
            int i = 0;
            while (i < feedList.size()) {
                feedMap = (Map)feedList.get(i);
                if (feedMap.get("entry") != null) break;
                ++i;
            }
            ArrayList entryList = null;
            if (feedMap.get("entry") instanceof HashMap) {
                entryList = new ArrayList();
                entryList.add(feedMap.get("entry"));
            } else if (feedMap.get("entry") instanceof ArrayList) {
                entryList = (ArrayList)feedMap.get("entry");
            } else {
                entryList = new ArrayList();
                int i2 = 0;
                while (i2 < feedList.size()) {
                    feedMap = (Map)feedList.get(i2);
                    if (feedMap.get("openSearch:totalResults") != null) break;
                    feedMap = null;
                    ++i2;
                }
                if (feedMap == null) {
                    throw new IllegalStateException("Cannot parse this entry from youtube.");
                }
            }
            ResponseListImpl<Comments> commentList = new ResponseListImpl<Comments>(entryList.size(), feedMap);
            int i3 = 0;
            while (i3 < entryList.size()) {
                Map contentMap = (Map)entryList.get(i3);
                CommentParser comment = new CommentParser(contentMap);
                commentList.add(comment);
                ++i3;
            }
            return commentList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

