/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.http;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import yt4droid.conf.CommentParameter;
import yt4droid.conf.ContactUserParameter;
import yt4droid.conf.RatingsParameter;
import yt4droid.conf.VideoMetaData;

public class HttpParameter {
    private String name = null;
    private String value = null;
    private File file = null;
    private String fileName = null;
    private int start;
    private int end;
    private InputStream fileBody = null;
    private static final String V3GPP = "video/3gpp";
    private VideoMetaData videoMetaData;
    private RatingsParameter rating;
    private CommentParameter comment;
    private ContactUserParameter contactUserParameter;
    private String atomString;

    public HttpParameter(CommentParameter comment, String videoId) {
        this.comment = comment;
        this.createContentParameter(videoId);
    }

    public HttpParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HttpParameter(File file, int start, int end) {
        this.file = file;
        this.start = start;
        this.end = end;
    }

    public HttpParameter(VideoMetaData videoMetaData, String fileName) {
        this.videoMetaData = videoMetaData;
        this.fileName = fileName;
        this.createVideoMetaData();
    }

    public HttpParameter(VideoMetaData videoMetaData) {
        this.videoMetaData = videoMetaData;
        this.createVideoMetaData();
    }

    public HttpParameter(RatingsParameter rating) {
        this.rating = rating;
        this.createRatingParameter();
    }

    public HttpParameter(ContactUserParameter contactUserParameter) {
        this.contactUserParameter = contactUserParameter;
        this.createContactParameter();
    }

    public static String encodeParameters(HttpParameter[] httpParams) {
        if (httpParams == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int j = 0;
        while (j < httpParams.length) {
            if (j != 0) {
                buf.append("&");
            }
            if (httpParams[j].value != null) {
                buf.append(HttpParameter.encode(httpParams[j].name)).append("=").append(HttpParameter.encode(httpParams[j].value));
            } else {
                buf.append(HttpParameter.encode(httpParams[j].name));
            }
            ++j;
        }
        return buf.toString();
    }

    public File getFile() {
        return this.file;
    }

    public boolean isFile() {
        return this.file != null;
    }

    public InputStream getFileBody() {
        return this.fileBody;
    }

    public boolean hasFileBody() {
        return this.fileBody != null;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public long getLength() {
        if (this.isFile()) {
            return this.file.length();
        }
        if (this.isMetaData()) {
            return this.atomString.length();
        }
        return 0L;
    }

    public boolean isMetaData() {
        return this.atomString != null;
    }

    public String getMetaData() {
        return this.atomString;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static String encode(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer(encoded.length());
        int i = 0;
        while (i < encoded.length()) {
            char focus = encoded.charAt(i);
            if (focus == '*') {
                buf.append("%2A");
            } else if (focus == '+') {
                buf.append("%20");
            } else if (focus == '%' && i + 1 < encoded.length() && encoded.charAt(i + 1) == '7' && encoded.charAt(i + 2) == 'E') {
                buf.append('~');
                i += 2;
            } else {
                buf.append(focus);
            }
            ++i;
        }
        return buf.toString();
    }

    public static boolean containsFile(HttpParameter[] params) {
        boolean containsFile = false;
        if (params == null) {
            return false;
        }
        HttpParameter[] httpParameterArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            HttpParameter param = httpParameterArray[n2];
            if (param.isFile() || param.isMetaData()) {
                containsFile = true;
                break;
            }
            ++n2;
        }
        return containsFile;
    }

    public String getContentType() {
        if (!this.isFile()) {
            throw new IllegalStateException("not a file");
        }
        return V3GPP;
    }

    public void createVideoMetaData() {
        StringBuilder atomString = new StringBuilder();
        atomString.append("<?xml version=\"1.0\"?>");
        atomString.append(" <entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:media=\"http://search.yahoo.com/mrss/\" xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">");
        atomString.append(" <media:group>");
        atomString.append(" <media:title type=\"plain\">" + this.videoMetaData.getTitle() + "</media:title>");
        atomString.append(" <media:description type=\"plain\">" + this.videoMetaData.getDescription() + "</media:description>");
        atomString.append(" <media:category scheme=\"http://gdata.youtube.com/schemas/2007/categories.cat\">" + this.videoMetaData.getCategory() + "</media:category>");
        atomString.append(" <media:keywords>" + this.videoMetaData.getTags() + "</media:keywords>");
        atomString.append(" </media:group> </entry>\r\n");
        if (this.videoMetaData.isContainLocation()) {
            atomString.append(" <georss:where xmlns:georss=\"http://www.georss.org/georss\" xmlns:gml=\"http://www.opengis.net/gml\">");
            atomString.append(" <gml:Point xmlns:gml=\"http://www.opengis.net/gml\"><gml:pos>");
            atomString.append(String.valueOf(String.valueOf(this.videoMetaData.getVideoLocationLatitude())) + " " + String.valueOf(this.videoMetaData.getVideoLocationLongitude()));
            atomString.append("</gml:pos></gml:Point></georss:where>");
        }
        this.atomString = atomString.toString();
    }

    public void createRatingParameter() {
        StringBuilder atomString = new StringBuilder();
        atomString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.rating.isLikeRating()) {
            atomString.append(" <entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">");
            atomString.append(" <yt:rating value=\"");
            atomString.append(this.rating.getLikeParameter());
        } else {
            atomString.append(" <entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:gd=\"http://schemas.google.com/g/2005\">");
            atomString.append(" <gd:rating value=\"");
            atomString.append(this.rating.getRating());
            atomString.append("\"");
            atomString.append(" min=\"");
            atomString.append(this.rating.getMinRating());
            atomString.append("\"");
            atomString.append(" max=\"");
            atomString.append(this.rating.getMaxRating());
        }
        atomString.append("\"/>");
        atomString.append("</entry>");
        this.atomString = atomString.toString();
    }

    public void createContentParameter(String videoId) {
        StringBuilder atomString = new StringBuilder();
        atomString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        atomString.append(" <entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">");
        if (this.comment.getCommentId() != null) {
            atomString.append(" <link rel=\"http://gdata.youtube.com/schemas/2007#in-reply-to\"");
            atomString.append(" type=\"application/atom+xml\" href=\"http://gdata.youtube.com/feeds/api/videos/");
            atomString.append(videoId);
            atomString.append("/comments/");
            atomString.append(this.comment.getCommentId());
            atomString.append("\"/>");
        }
        atomString.append(" <content>");
        atomString.append(this.comment.getComment());
        atomString.append("</content>");
        atomString.append("</entry>");
        this.atomString = atomString.toString();
    }

    public void createContactParameter() {
        StringBuilder atomString = new StringBuilder();
        atomString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        atomString.append(" <entry xmlns=\"http://www.w3.org/2005/Atom\" xmlns:yt=\"http://gdata.youtube.com/schemas/2007\">");
        atomString.append("<category scheme=\"http://gdata.youtube.com/schemas/2007/contact.cat\"");
        atomString.append(" term=\"");
        atomString.append(this.contactUserParameter.getTerms());
        atomString.append("\"/>");
        if (this.contactUserParameter.getStatus() != null) {
            atomString.append("<status>");
            atomString.append(this.contactUserParameter.getStatus());
            atomString.append("</status>");
        } else {
            atomString.append(" <yt:username>");
            atomString.append(this.contactUserParameter.getUserId());
            atomString.append("</yt:username>");
        }
        atomString.append("</entry>");
        this.atomString = atomString.toString();
    }
}

