/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.http;

import java.util.HashMap;
import java.util.Map;
import yt4droid.YoutubeException;
import yt4droid.auth.Authorization;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpClient;
import yt4droid.http.HttpClientFactory;
import yt4droid.http.HttpParameter;
import yt4droid.http.HttpRequest;
import yt4droid.http.HttpResponse;
import yt4droid.http.HttpResponseEvent;
import yt4droid.http.HttpResponseListener;
import yt4droid.http.RequestMethod;

public class HttpClientWrapper {
    private final Configuration conf;
    private final Map<String, String> requestHeaders;
    private HttpClient http;
    private HttpResponseListener httpResponseListener;

    public HttpClientWrapper(Configuration conf) {
        this.conf = conf;
        this.requestHeaders = conf.getRequestHeaders();
        this.http = HttpClientFactory.getInstance(conf);
    }

    private HttpResponse request(HttpRequest req) throws YoutubeException {
        HttpResponse res;
        try {
            res = this.http.request(req);
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(req, res, null));
            }
        }
        catch (YoutubeException ye) {
            if (this.httpResponseListener != null) {
                this.httpResponseListener.httpResponseReceived(new HttpResponseEvent(req, null, ye));
            }
            throw ye;
        }
        return res;
    }

    public void setHttpResponseListener(HttpResponseListener listener) {
        this.httpResponseListener = listener;
    }

    public HttpResponse get(String url, HttpParameter[] parameters, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.GET, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse get(String url, HttpParameter[] parameters) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.GET, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse get(String url, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse get(String url) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.GET, url, null, null, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse post(String url, HttpParameter[] parameters, Map<String, String> requestHeaders) throws YoutubeException {
        HashMap<String, String> headers = new HashMap<String, String>(this.requestHeaders);
        if (requestHeaders != null) {
            headers.putAll(requestHeaders);
        }
        return this.request(new HttpRequest(RequestMethod.POST, url, parameters, null, headers));
    }

    public HttpResponse post(String url, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse post(String url) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.POST, url, null, null, this.requestHeaders));
    }

    public HttpResponse delete(String url, HttpParameter[] parameters, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String url, HttpParameter[] parameters) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse delete(String url, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse delete(String url) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.DELETE, url, null, null, this.requestHeaders));
    }

    public HttpResponse head(String url, HttpParameter[] parameters, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse head(String url, HttpParameter[] parameters) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse head(String url, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse head(String url) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.HEAD, url, null, null, this.requestHeaders));
    }

    public HttpResponse put(String url, HttpParameter[] parameters, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, authorization, this.requestHeaders));
    }

    public HttpResponse put(String url, HttpParameter[] parameters) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, parameters, null, this.requestHeaders));
    }

    public HttpResponse put(String url, Authorization authorization) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, authorization, this.requestHeaders));
    }

    public HttpResponse put(String url) throws YoutubeException {
        return this.request(new HttpRequest(RequestMethod.PUT, url, null, null, this.requestHeaders));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpClientWrapper that = (HttpClientWrapper)o;
        if (!this.http.equals(that.http)) {
            return false;
        }
        if (!this.requestHeaders.equals(that.requestHeaders)) {
            return false;
        }
        return this.conf.equals(that.conf);
    }

    public int hashCode() {
        int result = this.conf.hashCode();
        result = 31 * result + this.http.hashCode();
        result = 31 * result + this.requestHeaders.hashCode();
        return result;
    }

    public String toString() {
        return "HttpClientWrapper{wrapperConf=" + this.conf + ", http=" + this.http + ", requestHeaders=" + this.requestHeaders + ", httpResponseListener=" + this.httpResponseListener + '}';
    }
}

