/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.conf;

import yt4droid.CategoryParam;

public class VideoMetaData {
    private String title;
    private String description;
    private CategoryParam category;
    private String tags;
    private double locationLatitude;
    private double locationLongitude;
    private boolean containLocation;

    private VideoMetaData(String title, String description, CategoryParam category, String tags) {
        this.title = title;
        this.description = description;
        this.category = category;
        this.tags = tags;
        this.containLocation = false;
    }

    private VideoMetaData(String title, String description, CategoryParam category, String tags, double locationLatitude, double locationLongitude) {
        this.title = title;
        this.description = description;
        this.category = category;
        this.tags = tags;
        this.locationLatitude = locationLatitude;
        this.locationLongitude = locationLongitude;
        this.containLocation = true;
    }

    public static VideoMetaData createVideoMetaDataWithLocation(String title, String description, CategoryParam category, String tags, double locationLatitude, double locationLongitude) {
        return new VideoMetaData(title, description, category, tags, locationLatitude, locationLongitude);
    }

    public static VideoMetaData createVideoMetaData(String title, String description, CategoryParam category, String tags) {
        return new VideoMetaData(title, description, category, tags);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return CategoryParam.paramAsString(this.category);
    }

    public String getTags() {
        return this.tags;
    }

    public double getVideoLocationLatitude() {
        return this.locationLatitude;
    }

    public double getVideoLocationLongitude() {
        return this.locationLongitude;
    }

    public boolean isContainLocation() {
        return this.containLocation;
    }
}

