/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.conf;

public class ContactUserParameter {
    private String userId;
    private String terms;
    private String status;

    private ContactUserParameter(String userId, Terms terms) {
        this.userId = userId;
        this.terms = Terms.asString(terms);
    }

    private ContactUserParameter(String userId, Terms terms, Statuses status) {
        this.userId = userId;
        this.terms = Terms.asString(terms);
        this.status = Statuses.asString(status);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTerms() {
        return this.terms;
    }

    public String getStatus() {
        return this.status;
    }

    public static ContactUserParameter createContactUserParameter(String userId, Terms terms) {
        if (userId == null) {
            throw new IllegalStateException("Cannot create contactUserParameter.");
        }
        return new ContactUserParameter(userId, terms);
    }

    public static ContactUserParameter createContactUserParameter(String userId, Terms terms, Statuses status) {
        if (userId == null) {
            throw new IllegalStateException("Cannot create contactUserParameter.");
        }
        return new ContactUserParameter(userId, terms, status);
    }

    public static enum Statuses {
        ACCEPTED,
        REQUESTED,
        PENDING;


        protected static String asString(Statuses statuses) {
            switch (statuses) {
                case ACCEPTED: {
                    return "accepted";
                }
                case REQUESTED: {
                    return "requested";
                }
                case PENDING: {
                    return "pending";
                }
            }
            return null;
        }
    }

    public static enum Terms {
        FRIEND,
        FAMILY;


        protected static String asString(Terms terms) {
            switch (terms) {
                case FRIEND: {
                    return "Friend";
                }
                case FAMILY: {
                    return "Family";
                }
            }
            return null;
        }
    }
}

