/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.conf;

import yt4droid.conf.Configuration;
import yt4droid.conf.ConfigurationBase;
import yt4droid.http.UploadVideoListener;

public class ConfigurationBuilder {
    private ConfigurationBase configurationBean = ConfigurationBase.getInstance();

    public ConfigurationBuilder setUseSSL(boolean useSSL) {
        this.checkNotBuilt();
        this.configurationBean.setUseSSL(useSSL);
        return this;
    }

    public ConfigurationBuilder setGZIPEnabled(boolean gzipEnabled) {
        this.checkNotBuilt();
        this.configurationBean.setGZIPEnabled(gzipEnabled);
        return this;
    }

    public ConfigurationBuilder setClientID(String clientID) {
        this.checkNotBuilt();
        this.configurationBean.setClientId(clientID);
        return this;
    }

    public ConfigurationBuilder setDeveloperKey(String developerKey) {
        this.checkNotBuilt();
        this.configurationBean.setDeveloperKey(developerKey);
        return this;
    }

    public ConfigurationBuilder setHttpProxyHost(String httpProxyHost) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyHost(httpProxyHost);
        return this;
    }

    public ConfigurationBuilder setHttpProxyUser(String httpProxyUser) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyUser(httpProxyUser);
        return this;
    }

    public ConfigurationBuilder setHttpProxyPassword(String httpProxyPassword) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyPassword(httpProxyPassword);
        return this;
    }

    public ConfigurationBuilder setHttpProxyPort(int httpProxyPort) {
        this.checkNotBuilt();
        this.configurationBean.setHttpProxyPort(httpProxyPort);
        return this;
    }

    public ConfigurationBuilder setHttpConnectionTimeout(int httpConnectionTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpConnectionTimeout(httpConnectionTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpReadTimeout(int httpReadTimeout) {
        this.checkNotBuilt();
        this.configurationBean.setHttpReadTimeout(httpReadTimeout);
        return this;
    }

    public ConfigurationBuilder setHttpRetryCount(int httpRetryCount) {
        this.checkNotBuilt();
        this.configurationBean.setHttpRetryCount(httpRetryCount);
        return this;
    }

    public ConfigurationBuilder setHttpRetryIntervalSeconds(int httpRetryIntervalSeconds) {
        this.checkNotBuilt();
        this.configurationBean.setHttpRetryIntervalSeconds(httpRetryIntervalSeconds);
        return this;
    }

    public ConfigurationBuilder setUploadVideoListener(UploadVideoListener uploadListener) {
        this.checkNotBuilt();
        this.configurationBean.setUploadListener(uploadListener);
        return this;
    }

    public Configuration build() {
        this.checkNotBuilt();
        this.configurationBean.cacheInstance();
        try {
            ConfigurationBase configurationBase = this.configurationBean;
            return configurationBase;
        }
        finally {
            this.configurationBean = null;
        }
    }

    private void checkNotBuilt() {
        if (this.configurationBean == null) {
            throw new IllegalStateException("Cannot use this builder any longer, build() has already been called");
        }
    }
}

