/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.auth;

import yt4droid.YoutubeException;
import yt4droid.http.HttpResponse;
import yt4droid.util.ResponseStringUtil;

public abstract class OAuthToken {
    private String token;
    private String userName;
    private String[] responseStr = null;

    public OAuthToken(String token, String userName) {
        this.token = token;
        this.userName = userName;
    }

    OAuthToken(HttpResponse response) throws YoutubeException {
        this(response.asString());
    }

    OAuthToken(String string) {
        this.responseStr = ResponseStringUtil.split(string, "\n");
        this.token = this.getParameter("Auth");
        this.userName = this.getParameter("YouTubeUser");
    }

    public String getToken() {
        return this.token;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getParameter(String parameter) {
        String value = null;
        String[] stringArray = this.responseStr;
        int n = this.responseStr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.startsWith(String.valueOf(parameter) + '=')) {
                value = ResponseStringUtil.split(str, "=")[1].trim();
                break;
            }
            ++n2;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthToken)) {
            return false;
        }
        OAuthToken that = (OAuthToken)o;
        if (!this.token.equals(that.token)) {
            return false;
        }
        return this.userName.equals(that.userName);
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = 31 * result + this.userName.hashCode();
        return result;
    }

    public String toString() {
        return "OAuthToken{token='" + this.token + '\'' + ", userName='" + this.userName + '}';
    }
}

