/*
 * Decompiled with CFR 0.152.
 */
package yt4droid.auth;

import yt4droid.YoutubeException;
import yt4droid.auth.AccessToken;
import yt4droid.auth.Auth;
import yt4droid.auth.Authorization;
import yt4droid.conf.Configuration;
import yt4droid.http.HttpClientWrapper;
import yt4droid.http.HttpParameter;
import yt4droid.http.HttpRequest;

public class OAuthAuthorization
implements Authorization,
Auth {
    private final Configuration conf;
    private HttpClientWrapper http;
    private AccessToken oAuthToken;
    private static final String SERVICE = "youtube";
    private static final String LOGING = "source";

    public OAuthAuthorization(Configuration conf) {
        this.conf = conf;
        this.http = new HttpClientWrapper(conf);
    }

    @Override
    public String getAccessToken() {
        if (this.oAuthToken != null) {
            return this.oAuthToken.getToken();
        }
        return null;
    }

    @Override
    public String getUserId() {
        if (this.oAuthToken != null) {
            return this.oAuthToken.getUserName();
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.oAuthToken != null && this.oAuthToken instanceof AccessToken;
    }

    @Override
    public String getAuthorizationHeader(HttpRequest req) {
        if (this.oAuthToken != null) {
            return this.oAuthToken.getToken();
        }
        return null;
    }

    @Override
    public void setAuthAccessToken(AccessToken accessToken) {
        this.oAuthToken = accessToken;
    }

    @Override
    public AccessToken getAuthAccessToken(String email, String password) throws YoutubeException {
        try {
            String url = this.conf.getOAuthAccessTokenURL();
            if (url.indexOf("http://") == 0) {
                url = "https://" + url.substring(7);
            }
            this.oAuthToken = new AccessToken(this.http.post(url, new HttpParameter[]{new HttpParameter("Email", email), new HttpParameter("Passwd", password), new HttpParameter("service", SERVICE), new HttpParameter(LOGING, LOGING)}, this));
            return this.oAuthToken;
        }
        catch (YoutubeException ye) {
            throw new YoutubeException(ye.getMessage());
        }
    }
}

