/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import java.io.File;
import yt4droid.Comments;
import yt4droid.Contact;
import yt4droid.Feeds;
import yt4droid.Paging;
import yt4droid.QueryBuilder;
import yt4droid.ResponseList;
import yt4droid.UpdateResult;
import yt4droid.UploadResult;
import yt4droid.UserProfile;
import yt4droid.Youtube;
import yt4droid.YoutubeBaseImpl;
import yt4droid.YoutubeException;
import yt4droid.auth.Authorization;
import yt4droid.conf.CommentParameter;
import yt4droid.conf.Configuration;
import yt4droid.conf.ContactUserParameter;
import yt4droid.conf.RatingsParameter;
import yt4droid.conf.VideoMetaData;
import yt4droid.http.HttpParameter;
import yt4droid.http.HttpResponse;

public class YoutubeImpl
extends YoutubeBaseImpl
implements Youtube {
    private final HttpParameter GDATA_VERSION = new HttpParameter("v", "2");
    private final HttpParameter USE_JSONC = new HttpParameter("alt", "jsonc");
    private final HttpParameter[] FEEDS_DEFAULT_PARAMS = new HttpParameter[]{this.GDATA_VERSION, this.USE_JSONC};
    private final HttpParameter[] COMMENTS_DEFAULT_PARAMS = new HttpParameter[]{this.GDATA_VERSION};
    private final HttpParameter[] CONTACTS_DEFAULT_PARAMS = new HttpParameter[]{this.GDATA_VERSION};
    private boolean isCancel;

    YoutubeImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
    }

    private HttpParameter[] mergeParameter(HttpParameter[] params, HttpParameter[] defParams) {
        if (params != null) {
            HttpParameter[] newParams = new HttpParameter[params.length + defParams.length];
            System.arraycopy(params, 0, newParams, 0, params.length);
            System.arraycopy(defParams, 0, newParams, params.length, defParams.length);
            return newParams;
        }
        return params;
    }

    private HttpParameter[] mergeParameter(HttpParameter[] query, HttpParameter[] params, HttpParameter[] defParams) {
        if (params != null) {
            HttpParameter[] newParams = new HttpParameter[query.length + params.length + defParams.length];
            System.arraycopy(query, 0, newParams, 0, query.length);
            System.arraycopy(params, 0, newParams, query.length, params.length);
            System.arraycopy(defParams, 0, newParams, query.length + params.length, defParams.length);
            return newParams;
        }
        return params;
    }

    private HttpResponse get(String url) throws YoutubeException {
        HttpResponse response = null;
        response = this.http.get(url, this.auth);
        return response;
    }

    private HttpResponse get(String url, HttpParameter[] parameters) throws YoutubeException {
        HttpResponse response = null;
        response = this.http.get(url, parameters, this.auth);
        return response;
    }

    private HttpResponse post(String url) throws YoutubeException {
        HttpResponse response = null;
        response = this.http.post(url, this.auth);
        return response;
    }

    private HttpResponse post(String url, HttpParameter[] parameters) throws YoutubeException {
        HttpResponse response = null;
        response = this.http.post(url, parameters, this.auth);
        return response;
    }

    private HttpResponse delete(String url) throws YoutubeException {
        HttpResponse response = null;
        response = this.http.delete(url, this.auth);
        return response;
    }

    private HttpResponse put(String url, HttpParameter[] parameters) throws YoutubeException {
        HttpResponse response = null;
        response = this.http.put(url, parameters, this.auth);
        return response;
    }

    @Override
    public UploadResult uploadVideo(File file, VideoMetaData videoMetaData) throws YoutubeException {
        this.isAuthEnabled();
        double fileSize = file.length();
        if (fileSize == 0.0) {
            throw new IllegalStateException("filesize = 0. Cannot upload this Video.");
        }
        UploadResult result = null;
        String uploadUrl = this.factory.uploadMetaData(this.post(this.conf.getBaseUploadURL(), new HttpParameter[]{new HttpParameter(videoMetaData, file.getName())}));
        int uploadChunk = this.conf.getChunkBufferSize();
        this.conf.setTotalBytesUpload(0);
        int start = 0;
        int end = -1;
        while (fileSize > 0.0) {
            end = fileSize - (double)uploadChunk > 0.0 ? start + uploadChunk - 1 : start + (int)fileSize - 1;
            result = this.factory.uploadVideo(this.post(uploadUrl, new HttpParameter[]{new HttpParameter(file, start, end)}));
            fileSize -= (double)uploadChunk;
            start = end + 1;
            if (this.isCanceled()) break;
        }
        return result;
    }

    @Override
    public ResponseList<Feeds> createMyUploadList(Paging paging) throws YoutubeException {
        this.isAuthEnabled();
        return this.factory.createUserUploadList(this.get(String.valueOf(this.conf.getBaseFeedsURL()) + "/users/default/uploads", this.mergeParameter(paging.asGetParameterArray(), this.FEEDS_DEFAULT_PARAMS)));
    }

    @Override
    public ResponseList<Feeds> createUserUploadList(String userName, Paging paging) throws YoutubeException {
        return this.factory.createUserUploadList(this.get(String.valueOf(this.conf.getBaseFeedsURL()) + "/users/" + userName + "/uploads", this.mergeParameter(paging.asGetParameterArray(), this.FEEDS_DEFAULT_PARAMS)));
    }

    @Override
    public ResponseList<Comments> createCommentsList(String videoId, Paging paging) throws YoutubeException {
        return this.factory.createCommentsList(this.get(this.conf.getBaseCommentsURL(videoId), this.mergeParameter(paging.asGetParameterArray(), this.COMMENTS_DEFAULT_PARAMS)));
    }

    @Override
    public ResponseList<Feeds> createFeedsWithQuery(QueryBuilder query, Paging paging) throws YoutubeException {
        return this.factory.createFeedsListFromQuery(this.get(String.valueOf(this.conf.getBaseFeedsURL()) + "/videos", this.mergeParameter(query.asGetParameterArray(), paging.asGetParameterArray(), this.FEEDS_DEFAULT_PARAMS)));
    }

    @Override
    public UpdateResult updateRatings(String videoId, RatingsParameter rating) throws YoutubeException {
        this.isAuthEnabled();
        return this.factory.updateRatings(this.post(this.conf.getBaseRatingsURL(videoId), new HttpParameter[]{new HttpParameter(rating)}));
    }

    @Override
    public UpdateResult updateComments(String videoId, CommentParameter comment) throws YoutubeException {
        this.isAuthEnabled();
        return this.factory.updateComment(this.post(this.conf.getBaseCommentsURL(videoId), new HttpParameter[]{new HttpParameter(comment, videoId)}));
    }

    @Override
    public UpdateResult deleteVideo(String videoId) throws YoutubeException {
        this.isAuthEnabled();
        return this.factory.deleteVideo(this.delete(this.conf.getBaseVideoUpdateURL(videoId, this.getAuthorization().getUserId())));
    }

    @Override
    public UpdateResult updateVideo(String videoId, VideoMetaData videoMetaData) throws YoutubeException {
        this.isAuthEnabled();
        return this.factory.updateVideo(this.put(this.conf.getBaseVideoUpdateURL(videoId, this.getAuthorization().getUserId()), new HttpParameter[]{new HttpParameter(videoMetaData)}));
    }

    @Override
    public UserProfile createUserProfile(String userId) throws YoutubeException {
        return this.factory.createUserProfile(this.get(this.conf.getBaseUserProfileURL(userId)));
    }

    @Override
    public ResponseList<Contact> createMyContactList(Paging paging) throws YoutubeException {
        this.isAuthEnabled();
        return this.factory.createMyContacts(this.get(this.conf.getBaseContactURL(), this.mergeParameter(paging.asGetParameterArray(), this.CONTACTS_DEFAULT_PARAMS)));
    }

    @Override
    public ResponseList<Contact> createContactList(String userName, Paging paging) throws YoutubeException {
        return this.factory.createMyContacts(this.get(this.conf.getBaseContactURL(userName), this.mergeParameter(paging.asGetParameterArray(), this.CONTACTS_DEFAULT_PARAMS)));
    }

    @Override
    public UpdateResult addContact(ContactUserParameter contactParam) throws YoutubeException {
        this.isAuthEnabled();
        return this.factory.addContact(this.post(this.conf.getBaseContactURL(), new HttpParameter[]{new HttpParameter(contactParam)}));
    }

    @Override
    public UpdateResult updateContact(ContactUserParameter contactParam) throws YoutubeException {
        if (contactParam.getTerms() == null && contactParam.getStatus() == null) {
            throw new IllegalStateException("Cannot update contact.");
        }
        this.isAuthEnabled();
        return this.factory.updateContact(this.put(this.conf.getBaseContactURL(this.getAuthorization().getUserId(), contactParam.getUserId()), new HttpParameter[]{new HttpParameter(contactParam)}));
    }

    @Override
    public synchronized void uploadCanceled() {
        this.isCancel = true;
    }

    private synchronized boolean isCanceled() {
        return this.isCancel;
    }
}

