/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import java.util.Date;
import java.util.List;
import java.util.Map;
import yt4droid.StatisticsEntity;
import yt4droid.YoutubeException;
import yt4droid.util.ParseUtil;

public class StatisticsEntityImpl
implements StatisticsEntity {
    private Date lastWebAccess;
    private int subscriberCount;
    private int videoWatchCount;
    private int viewCount;
    private int totalUploadViews;

    public StatisticsEntityImpl(List<Map<String, String>> statisticsList) throws YoutubeException {
        this.init(statisticsList);
    }

    private void init(List<Map<String, String>> statisticsList) throws YoutubeException {
        for (Map<String, String> map : statisticsList) {
            if (map.get("lastWebAccess") != null) {
                this.lastWebAccess = ParseUtil.parseDate(map.get("lastWebAccess"));
            }
            if (map.get("subscriberCount") != null) {
                this.subscriberCount = ParseUtil.getInt(map.get("subscriberCount"));
            }
            if (map.get("videoWatchCount") != null) {
                this.videoWatchCount = ParseUtil.getInt(map.get("videoWatchCount"));
            }
            if (map.get("viewCount") != null) {
                this.viewCount = ParseUtil.getInt(map.get("viewCount"));
            }
            if (map.get("totalUploadViews") == null) continue;
            this.totalUploadViews = ParseUtil.getInt(map.get("totalUploadViews"));
        }
    }

    @Override
    public Date getLastWebAccess() {
        return this.lastWebAccess;
    }

    @Override
    public int getSubscriberCount() {
        return this.subscriberCount;
    }

    @Override
    public int getVideoWatchCount() {
        return this.videoWatchCount;
    }

    @Override
    public int getViewCount() {
        return this.viewCount;
    }

    @Override
    public int getTotalUploadViews() {
        return this.totalUploadViews;
    }
}

