/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import junit.framework.TestCase;
import yt4droid.CategoryParam;
import yt4droid.LocationEntity;
import yt4droid.OrderByParam;
import yt4droid.QueryBuilder;
import yt4droid.SafeSearchParam;
import yt4droid.TimeParam;
import yt4droid.http.HttpParameter;

public class QueryTest
extends TestCase {
    private HttpParameter[] params;

    public QueryTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testQuery() {
        QueryBuilder query = new QueryBuilder();
        try {
            query.build();
            QueryTest.fail((String)"The parameter is not set.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            query.setCaption();
            QueryTest.fail((String)"Cannot use this builder any longer.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        query = new QueryBuilder();
        query.setCaption();
        query.setCategory(CategoryParam.ANIMALS);
        query.setFormat("1");
        LocationEntity location = new LocationEntity(1.123456, 1.789123);
        query.setLocation(location);
        query.setLr("en");
        query.setOrderBy(OrderByParam.PUBLISHED);
        query.setQ("youtube");
        query.setRestriction("restriction");
        query.setSafeSearch(SafeSearchParam.MODERATE);
        query.setTime(TimeParam.ALL_TIME);
        query.setUploader("yt4droid");
        query.build();
        QueryTest.assertEquals((int)12, (int)query.asGetParameterArray().length);
        this.params = query.asGetParameterArray();
        QueryTest.assertEquals((String)"caption", (String)this.params[0].getName());
        QueryTest.assertEquals((String)"category", (String)this.params[1].getName());
        QueryTest.assertEquals((String)"format", (String)this.params[2].getName());
        QueryTest.assertEquals((String)"location", (String)this.params[3].getName());
        QueryTest.assertEquals((String)"location-radius", (String)this.params[4].getName());
        QueryTest.assertEquals((String)"lr", (String)this.params[5].getName());
        QueryTest.assertEquals((String)"orderby", (String)this.params[6].getName());
        QueryTest.assertEquals((String)"q", (String)this.params[7].getName());
        QueryTest.assertEquals((String)"restriction", (String)this.params[8].getName());
        QueryTest.assertEquals((String)"safeSearch", (String)this.params[9].getName());
        QueryTest.assertEquals((String)"time", (String)this.params[10].getName());
        QueryTest.assertEquals((String)"uploader", (String)this.params[11].getName());
        QueryTest.assertEquals(null, (String)this.params[0].getValue());
        QueryTest.assertEquals((String)"Category", (String)this.params[1].getValue());
        QueryTest.assertEquals((String)"1", (String)this.params[2].getValue());
        QueryTest.assertEquals((String)"1.123456", (String)this.params[3].getValue());
        QueryTest.assertEquals((String)"1.789123", (String)this.params[4].getValue());
        QueryTest.assertEquals((String)"en", (String)this.params[5].getValue());
        QueryTest.assertEquals((String)"published", (String)this.params[6].getValue());
        QueryTest.assertEquals((String)"youtube", (String)this.params[7].getValue());
        QueryTest.assertEquals((String)"restriction", (String)this.params[8].getValue());
        QueryTest.assertEquals((String)"moderate", (String)this.params[9].getValue());
        QueryTest.assertEquals((String)"all_time", (String)this.params[10].getValue());
        QueryTest.assertEquals((String)"yt4droid", (String)this.params[11].getValue());
        query = new QueryBuilder();
        query.setLocation(null);
        query.setUploader("yt4droid");
        query.build();
        QueryTest.assertEquals((int)1, (int)query.asGetParameterArray().length);
    }
}

