/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

import java.util.ArrayList;
import yt4droid.CategoryParam;
import yt4droid.LocationEntity;
import yt4droid.OrderByParam;
import yt4droid.Query;
import yt4droid.SafeSearchParam;
import yt4droid.TimeParam;
import yt4droid.http.HttpParameter;

public class QueryBuilder
implements Query {
    private ArrayList<HttpParameter> paramList;
    private HttpParameter[] httpParams;
    private boolean caption;
    private String category;
    private String format;
    private LocationEntity location;
    private String lr;
    private OrderByParam orderby;
    private String q;
    private String restriction;
    private SafeSearchParam safeSearch;
    private TimeParam time;
    private String uploader;

    @Override
    public QueryBuilder setCaption() {
        this.isBuild();
        this.caption = true;
        return this;
    }

    @Override
    public QueryBuilder setCategory(CategoryParam category) {
        this.isBuild();
        this.category = CategoryParam.paramAsString(category);
        return this;
    }

    @Override
    public QueryBuilder setFormat(String format) {
        this.isBuild();
        this.format = format;
        return this;
    }

    @Override
    public QueryBuilder setLocation(LocationEntity locationEntity) {
        this.isBuild();
        this.location = locationEntity;
        return this;
    }

    @Override
    public QueryBuilder setLr(String iso639_1Code) {
        this.isBuild();
        this.lr = iso639_1Code;
        return this;
    }

    @Override
    public QueryBuilder setOrderBy(OrderByParam param) {
        this.isBuild();
        this.orderby = param;
        return this;
    }

    @Override
    public QueryBuilder setQ(String q) {
        this.isBuild();
        this.q = q;
        return this;
    }

    @Override
    public QueryBuilder setRestriction(String restriction) {
        this.isBuild();
        this.restriction = restriction;
        return this;
    }

    @Override
    public QueryBuilder setSafeSearch(SafeSearchParam param) {
        this.isBuild();
        this.safeSearch = param;
        return this;
    }

    @Override
    public QueryBuilder setTime(TimeParam param) {
        this.isBuild();
        this.time = param;
        return this;
    }

    @Override
    public QueryBuilder setUploader(String uploader) {
        this.isBuild();
        this.uploader = uploader;
        return this;
    }

    private void isBuild() {
        if (this.paramList != null) {
            throw new IllegalStateException("Cannot use this builder any longer.");
        }
    }

    @Override
    public QueryBuilder build() {
        this.paramList = new ArrayList();
        if (this.caption) {
            this.paramList.add(new HttpParameter("caption", null));
        }
        if (this.category != null) {
            this.paramList.add(new HttpParameter("category", this.category));
        }
        if (this.format != null) {
            this.paramList.add(new HttpParameter("format", this.format));
        }
        if (this.location != null) {
            this.paramList.add(new HttpParameter("location", this.location.getLoacationAsString()));
            this.paramList.add(new HttpParameter("location-radius", this.location.getLocationRadiusAsString()));
        }
        if (this.lr != null) {
            this.paramList.add(new HttpParameter("lr", this.lr));
        }
        if (this.orderby != null) {
            this.paramList.add(new HttpParameter("orderby", OrderByParam.paramAsString(this.orderby)));
        }
        if (this.q != null) {
            this.paramList.add(new HttpParameter("q", this.q));
        }
        if (this.restriction != null) {
            this.paramList.add(new HttpParameter("restriction", this.restriction));
        }
        if (this.safeSearch != null) {
            this.paramList.add(new HttpParameter("safeSearch", SafeSearchParam.paramAsString(this.safeSearch)));
        }
        if (this.time != null) {
            this.paramList.add(new HttpParameter("time", TimeParam.paramAsString(this.time)));
        }
        if (this.uploader != null) {
            this.paramList.add(new HttpParameter("uploader", this.uploader));
        }
        if (this.paramList.size() == 0) {
            throw new IllegalStateException("The parameter is not set.");
        }
        return this;
    }

    public HttpParameter[] asGetParameterArray() {
        if (this.paramList == null) {
            throw new IllegalStateException("not build.");
        }
        this.httpParams = this.paramList.toArray(new HttpParameter[0]);
        return this.httpParams;
    }
}

