/*
 * Decompiled with CFR 0.152.
 */
package yt4droid;

public class EmbedTagBuilder {
    private int width;
    private int height;
    private String videoId;
    private String norel;
    private String https;
    private String privacy;

    public EmbedTagBuilder(String videoId, int width, int height) {
        this.width = width;
        this.height = height;
        this.videoId = videoId;
    }

    public EmbedTagBuilder setNoRel() {
        if (this.norel == null) {
            this.norel = "rel=0";
        }
        return this;
    }

    public EmbedTagBuilder setHttps() {
        if (this.https == null) {
            this.https = "https";
        }
        return this;
    }

    public EmbedTagBuilder setPrivacy() {
        if (this.privacy == null) {
            this.privacy = "://www.youtube-nocookie.com/embed/";
        }
        return this;
    }

    public String build() {
        StringBuilder embedTag = new StringBuilder();
        embedTag.append("<iframe width=\"");
        embedTag.append(String.valueOf(this.width));
        embedTag.append("\" height=\"");
        embedTag.append(String.valueOf(this.height));
        embedTag.append("\" src=\"");
        if (this.https != null) {
            embedTag.append(this.https);
        } else {
            embedTag.append("http");
        }
        if (this.privacy != null) {
            embedTag.append(this.privacy);
        } else {
            embedTag.append("://www.youtube.com/embed/");
        }
        embedTag.append(this.videoId);
        if (this.norel != null) {
            embedTag.append("?" + this.norel);
        }
        embedTag.append("\" frameborder=\"0\" allowfullscreen></iframe>");
        return embedTag.toString();
    }
}

