# -*- coding: utf-8 -*-
# vi:ts=4:et
# $Id: util.py,v 1.2 2004/05/14 08:14:32 etale Exp $
# =====================================================
"""library for utility functions.
"""
__all__ = [
        'is_integer',
        'is_non_negative_integer',
        'flatten_tableau',
        'pairwise',
        ]
import itertools

try:
    reversed
except NameError:
    from compat import reversed, tee
    itertools.tee = tee

def is_integer(n):
    """is_integer(n) -> Tests whether or not n is an integer."""
    return isinstance(n, (int, long))

def is_non_negative_integer(n):
    """is_non_negative_integer(n) -> Tests whether or not n in a non-negative integer."""
    return is_integer(n) and n >= 0

def flatten_tableau(iterable, reverse=False):
    """This function is used to flatten a tableau"""
    if reverse:
        iterable = reversed(iterable)
    for row in iterable:
        for col in row:
            yield col

def pairwise(iterable):
    "s -> (s0,s1), (s1,s2), (s2, s3), ..."
    # This function is taken from an example in the library.
    # See : http://docs.python.org/lib/itertools-example.html
    a, b = itertools.tee(iterable)
    try:
        b.next()
    except StopIteration:
        pass
    return itertools.izip(a, b)


