# -*- coding: utf-8 -*-
# vi:ts=4:et
# $Id: test_permgroup.py,v 1.1 2004/01/11 10:47:58 etale Exp $
# =====================================================
"""
unittest for young.py
"""
import unittest

from test import test_support

from young import *


__all__ = [
           'to_cycle',
           'symmgroup',
           'SymmetricGroup',
           ]

data = [
    [PermGroup([4, 3, 1, 2]), PermGroup([3, 4, 2, 1]), -1, 5, 2, 2],
    [PermGroup([2, 1, 3, 4]), PermGroup([2, 1, 3, 4]), -1, 1, 1, 3],
    [PermGroup([3, 4, 1, 2]), PermGroup([3, 4, 1, 2]),  1, 4, 2, 2],
    [PermGroup([2, 1, 4, 3]), PermGroup([2, 1, 4, 3]),  1, 2, 2, 2],
    [PermGroup([3, 1, 4, 2]), PermGroup([2, 4, 1, 3]), -1, 3, 2, 2],
    [PermGroup([2, 4, 1, 3]), PermGroup([3, 1, 4, 2]), -1, 3, 2, 2],
    [PermGroup([3, 1, 2, 4]), PermGroup([2, 3, 1, 4]),  1, 2, 1, 2],
    [PermGroup([4, 2, 1, 3]), PermGroup([3, 2, 4, 1]),  1, 4, 1, 2],
    [PermGroup([4, 1, 3, 2]), PermGroup([2, 4, 3, 1]),  1, 4, 1, 2],
    [PermGroup([2, 3, 1, 4]), PermGroup([3, 1, 2, 4]),  1, 2, 2, 3],
    [PermGroup([1, 4, 3, 2]), PermGroup([1, 4, 3, 2]), -1, 3, 1, 3],
    [PermGroup([2, 3, 4, 1]), PermGroup([4, 1, 2, 3]), -1, 3, 3, 3],
    [PermGroup([1, 3, 4, 2]), PermGroup([1, 4, 2, 3]),  1, 2, 2, 3],
    [PermGroup([2, 4, 3, 1]), PermGroup([4, 1, 3, 2]),  1, 4, 2, 3],
    [PermGroup([1, 3, 2, 4]), PermGroup([1, 3, 2, 4]), -1, 1, 1, 3],
    [PermGroup([4, 2, 3, 1]), PermGroup([4, 2, 3, 1]), -1, 5, 1, 3],
    [PermGroup([4, 1, 2, 3]), PermGroup([2, 3, 4, 1]), -1, 3, 1, 1],
    [PermGroup([3, 2, 1, 4]), PermGroup([3, 2, 1, 4]), -1, 3, 1, 3],
    [PermGroup([1, 4, 2, 3]), PermGroup([1, 3, 4, 2]),  1, 2, 1, 2],
    [PermGroup([3, 2, 4, 1]), PermGroup([4, 2, 1, 3]),  1, 4, 2, 3],
    [PermGroup([1, 2, 4, 3]), PermGroup([1, 2, 4, 3]), -1, 1, 1, 3],
    [PermGroup([3, 4, 2, 1]), PermGroup([4, 3, 1, 2]), -1, 5, 2, 2],
    [PermGroup([1, 2, 3, 4]), PermGroup([1, 2, 3, 4]),  1, 0, 0, 4],
    [PermGroup([4, 3, 2, 1]), PermGroup([4, 3, 2, 1]),  1, 6, 2, 2],
    ]

class TestPermGroup(unittest.TestCase):
    def test_inverse(self):
        r = range(1, 5)
        unit = permgroup(r)
        for sample in data:
            self.assertEqual(sample[0].get_inverse(), sample[1])
            self.assertEqual(sample[1].get_inverse(), sample[0])
            self.assertEqual(sample[0] * sample[1], unit)
            self.assertEqual(sample[1] * sample[0], unit)

    def test_signature(self):
        for sample in data:
            sgn = sample[0].get_sgn()
            #self.assertEqual(sample[0].get_sgn(), sample[2])
            self.assertEqual(sgn, sample[2])
            if sample[0].iseven():
                self.assertEqual(sgn, 1)
            else:
                self.assertEqual(sgn, -1)

    def test_inversion(self):
        for sample in data:
            self.assertEqual(sample[0].get_inversion(), sample[3])

    def test_excedance(self):
        for sample in data:
            self.assertEqual(sample[0].excedance(), sample[4])

    def test_weak_excedance(self):
        for sample in data:
            self.assertEqual(sample[0].weak_excedance(), sample[5])


class TestSymm(unittest.TestCase):
    def test_symm(self):
        n = 4
        symm = SymmetricGroup(n)
        self.assert_(symm.get_order(), n)


    def test_signature(self):
        n = 4
        symm = SymmetricGroup(n)
        even = symm.get_even()
        odd  = symm.get_odd()
        for e in even:
            self.assertEqual(e.get_sgn(), 1)
            self.assertEqual(e.get_inv()%2, 0)

        for o in odd:
            self.assertEqual(o.get_sgn(), -1)
            self.assertEqual(o.get_inv()%2, 1)


class TestCycle(unittest.TestCase):
    def test_cycle(self):

        # list
        data = (
            ([3, 1, 2], [(1, 2, 3)]),
            ([2, 1, 3], [(1, 2), (3,)]),
            ([1, 3, 2], [(1,), (2, 3)]),
            ([2, 3, 1], [(1, 2, 3)]),
            ([1, 2, 3], [(1,), (2,), (3,)]),
            ([3, 2, 1], [(1, 3), (2,)]),
        )

        # tuple
        # lisp like?
        data = (
            ((3, 1, 2), ((1, 2, 3),)),
            ((2, 1, 3), ((1, 2), (3,))),
            ((1, 3, 2), ((1,), (2, 3))),
            ((2, 3, 1), ((1, 2, 3),)),
            ((1, 2, 3), ((1,), (2,), (3,))),
            ((3, 2, 1), ((1, 3), (2,))),
        )

        for p, cycle in data:
            self.assertEqual(tuple(permgroup(p).to_cycle()), cycle)
            #self.assertEqual(list(permgroup(p).to_cycle()), cycle)

def test_main(verbose=None):
    testclasses = (
            TestPermGroup,
            TestSymm,
            TestCycle,
            )

    test_support.run_unittest(*testclasses)

if __name__ == '__main__':
    test_main()
