# vim fileencoding=utf-8
# vi:ts=4:et
# $Id: test_partition.py,v 1.3 2004/05/15 09:01:42 etale Exp $
# =====================================================

"""
unittest for partition.py
"""
import sets
import unittest
from test import test_support

from young import *


class TestPartition(unittest.TestCase):
    def test_repr_str(self):
        for i in range(5):
            part = partition(i)

            `part`
            print part

            repr(part)
            str(part)

            part.__repr__()
            part.__str__()

            "%r"%part
            "%s"%part

    def test_partition_size(self):
        for i in range(10):
            for part in partition(i):
                self.assertEqual(i, sum(part))

    def test_up(self):
        expectations = [
                [(1,1,1), ((2,1,1), (1,1,1,1))],
                [(2,1), ((3,1), (2,2), (2,1,1))],
                [(3,), ((4,), (3,1))],
            ]

        for shape, expectation in expectations:
            part = Partition(shape)
            self.assertEqual(sets.Set(part.up()), sets.Set(expectation))

    def test_down(self):
        expectations = [
                [(1,1,1,1), ((1,1,1),)],
                [(2,1,1), ((1,1,1), (2,1))],
                [(2,2), ((2,1),)],
                [(3,1), ((2,1), (3,))],
                [(4,), ((3,),)],
            ]

        for shape, expectation in expectations:
            part = Partition(shape)
            self.assertEqual(sets.Set(part.down()), sets.Set(expectation))

class TestPartitionConjugate(unittest.TestCase):
    # test of Partition.conjugate
    # Stanley EC1 p.39

    def check(self, p1, p2):
        self.assertEqual(Partition(p1).conjugate(), Partition(p2))
        self.assertEqual(Partition(p2).conjugate(), Partition(p1))

    def test_conjugate1(self):
        self.check((4,3,1,1,1), (5,2,2,1))

    def test_conjugate2(self):
        self.check((1,1), (2,))

    def test_conjugate3(self):
        self.check((1,), (1,))

    def test_conjugate_suite(self):

        # The next expectations is a partition of 6.
        expectations = (
            [(1, 1, 1, 1, 1, 1), (6,)],
            [(2, 1, 1, 1, 1), (5, 1)],
            [(2, 2, 1, 1), (4, 2)],
            [(2, 2, 2), (3, 3)],
            [(3, 1, 1, 1), (4, 1, 1)],
            [(3, 2, 1), (3, 2, 1)],
            [(3, 3), (2, 2, 2)],
            [(4, 1, 1), (3, 1, 1, 1)],
            [(4, 2), (2, 2, 1, 1)],
            [(5, 1), (2, 1, 1, 1, 1)],
            [(6,), (1, 1, 1, 1, 1, 1)],
            )

        for part, expectation in expectations:
            part, expectation = Partition(part), Partition(expectation)
            self.assertEqual(part.conjugate(), expectation)

class  TestSeqOfPartition(unittest.TestCase):
    def test_size(self):
        expectations = [1, 1, 2, 3, 5, 7, 11, 15, 22, 30, 42, 56, 77, 101, 135, 176, 231, 297, 385, 490]

        for i, expectation in enumerate(expectations):
            self.assertEqual(partition(i).size(), expectation)

    def test_add(self):
        empty = partition(0)
        part = partition(10)
        for p in part:
            empty.add(p)
        self.assertEqual(sets.Set(empty), sets.Set(part))

    def test_distinct(self):
        expectations = [
            [] ,
            [(1,)] ,
            [(2,)] ,
            [(3,), (2,1)] ,
            [(4,), (3,1)] ,
            [(5,), (4,1), (3,2)] ,
            [(6,), (5,1), (4,2), (3,2,1)] ,
            [(7,), (6,1), (5,2), (4,3), (4,2,1)] ,
            [(8,), (7,1), (6,2), (5,3), (5,2,1), (4,3,1)] ,
            [(9,), (8,1), (7,2), (6,3), (6,2,1), (5,4), (5,3,1), (4,3,2)] ,
            ]

        for i, expectation in enumerate(expectations):
            self.assertEqual(sets.Set(partition(i).distinct()),
                    sets.Set(expectation))


class TestPartitionDistinct(unittest.TestCase):
    def test_partition_distinct(self):
        test_vectors = [
            [(6,), True],
            [(5,1), True],
            [(4,2), True],
            [(4,1,1), False],
            [(3,3), False],
            [(3,2,1), True],
            [(3,1,1,1), False],
            [(2,2,2), False],
            [(2,2,1,1), False],
            [(2,1,1,1,1), False],
            [(1,1,1,1,1,1), False],
            ]
        for partition, expectation in test_vectors:
            self.assertEqual(Partition(partition).isdistinct(), expectation)

class TestNumberOfPartition(unittest.TestCase):
    def test_number_of_partition_with_k(self):
        expectations = [0,1,2,2,1,1,0]
        for i, expectation in enumerate(expectations):
            self.assertEqual(expectation, number_of_partition(5, i))

    def test_number_of_partition(self):
        expectations = [1, 1, 2, 3, 5, 7, 11, 15, 22, 30, 42, 56, 77, 101, 135, 176, 231, 297, 385, 490]

        for i, expectation in enumerate(expectations):
            self.assertEqual(partition(i).size(), expectation)

def test_main(verbose=None):
    testclasses = (
            TestPartition,
            TestPartitionConjugate,
            TestPartitionDistinct,
            TestSeqOfPartition,
            TestNumberOfPartition,
            )

    test_support.run_unittest(*testclasses)

if __name__ == '__main__':
    test_main()

