# -*- coding: utf-8 -*-
# vi:ts=4:et
# $Id: test_iterator.py,v 1.1 2004/01/11 10:47:58 etale Exp $
# =====================================================

"""unittest for iterator.py
"""

import unittest
from test import test_support

from young import *

class TestBasicOps(unittest.TestCase):
    def test_drop(self):
        # Test stop=None

        for args, tgtargs in [  # Stop when seqn is exhausted
                ((0, ), (100, )),
                ((10, ), (10, 100)),
                ((100, ), (100, 100)),
                ((1, 2), (1, 100, 2)),
                ((200, ), (200, 100)),
                ]:

            self.assertEqual(list(drop(xrange(100), *args)), range(*tgtargs))


    def test_take(self):
        for args in [          # take(args) should agree with range(args)
                (10, 20, 3),
                (10, 3, 20),
                (10, 20),
                (10, 3),
                (20,)
                ]:
            self.assertEqual(list(take(xrange(100), *args)), range(*args))

        for args, tgtargs in [  # Stop when seqn is exhausted
                ((10, 110, 3), ((10, 100, 3))),
                ((10, 110), ((10, 100))),
                ((110,), (100,))
                ]:
            self.assertEqual(list(take(xrange(100), *args)), range(*tgtargs))


def test_main(verbose=None):
    test_classes = (TestBasicOps, 
            )
    test_support.run_unittest(*test_classes)

if __name__ == "__main__":
    test_main(verbose=True)
