#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# vi:ts=4:et
# $Date: 2003/08/15 13:35:09 $
# $Revision: 1.1 $
# =====================================================

"""library for error handling"""

import sys

class Error(Exception):
    """Base class for young module exceptions."""
    def __init__(self, msg):
        self.msg = msg
        Exception.__init__(self, msg)

    def __repr__(self):
        return self.msg

    __str__ = __repr__

class ArgumentError(Error):
    """Raised when an invalid argument was found"""
    def __init__(self, msg, *args, **kw):
        msg = "Invalid argument : " + msg
        if args:
            msg += "\n\targs: %s"%`args`
        if kw:
            msg += "\n\tkw  : %s"%`kw`
        Error.__init__(self, msg)

class PartitionError(Error):
    """Raised when error occurred while processing partition"""
    def __init__(self, msg):
        Error.__init__(self, msg)

class PartitionFormatError(Error):
    """Raised when malformed partition was found"""
    def __init__(self, msg, aPartition):
        Error.__init__(self, msg + " : " + str(aPartition))
        self.aPartition = aPartition

class YoungError(Error):
    """Raised when error occurred while processing Young tableaux"""
    def __init__(self, msg):
        Error.__init__(self, msg)

class YoungFormatError(Error):
    """Raised when malformed diagram was found"""
    def __init__(self, msg, diagram):
        Error.__init__(self, msg + "\n" + str(diagram))
        self.diagram = diagram

class GroupError(Error):
    def __init__(self, msg):
        Error.__init__(self, msg)

