#!/bin/sh

#Copyright (C) 2006, 2007 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み 
export EXEC_PATH=${0%/*}

. ${EXEC_PATH}/install.cfg

echo ""
                                                                                
echo "###################################################################"
echo "###                                                             ###"
echo "### 運用管理ソフトウェア Hinemos  エージェント                  ###"
echo "###                                   インストーラ   Ver 2.3.0  ###"
echo "###                                                             ###"
echo "###  Copyright (C) 2006,2007 NTT DATA Corporation.              ###"
echo "###################################################################"


EXEC_USER=`/usr/bin/whoami`
HOSTS_FILE=/etc/hosts
HOST=`hostname`

# check for incorrect user

if [ $EXEC_USER != "root" ]; then
        echo "";
        echo "ERROR  Hinemos Agentのインストールはrootでおこなってください。 ";
        echo "";
        exit 1;
fi

pre_install() {
	##
	## hostsファイルのチェック START
	##
	echo ""
	echo "インストールを行う前に、${HOSTS_FILE} のチェックを行います。"

	#ホスト名にIPアドレスの重複がないかチェックを行う
	check_flg=`grep ${HOST} ${HOSTS_FILE} | grep -v ^\# | awk '{print $1}' | wc -l`
	
	if [ ${check_flg} != 1 ]; then
	    echo "NG"
	    echo "${HOSTS_FILE} には、${HOST} に対してIPアドレスの設定が行われていないか、2つ以上のIPアドレスが設定されています。"
	    echo "${HOSTS_FILE} を確認し、${HOST} とIPアドレスが1対1となるように設定を変更して下さい。"
	    echo ""
	    
	    while [ 1 ]; do
	    	echo "インストールを続けますか？（Y：続ける / N：中止する ）"
	    	read ANS
	    	case ${ANS} in
	    		y|Y)
	    	  		break
	    	  	;;
	    		n|N)
			  		echo "インストールを中止します。"
			  		echo ""
			  		exit 1
			  	;;
		    	*)
			esac
		done
		
	else
	    echo "OK"
	fi
	
	##
	## hostsファイルのチェック END
	##
	
	
	##
	## パッケージのチェック START
	##
	echo ""
	echo "インストールを行う前に、パッケージのチェックを行います。"
	
	# パッケージの有無をチェックする
	rpm_check() {
	    rpm -qi $1 >/dev/null 2>&1
	    check_flg=$?
	}
	
	# マニュアルに記述されているパッケージの有無をチェックする
	for p_name in ${CHECK_MAN[@]}
	do
	    rpm_check ${p_name}
	    if [ ${check_flg} = 1 ]; then
	        echo ${p_name} >> ${EXEC_PATH}/tmp.txt
	    fi
	done
	
	# 結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
	    echo ""
	    echo "NG"
	    echo "Hinemosエージェントをインストールするには以下のパッケージが不足しています。"
	    cat ${EXEC_PATH}/tmp.txt
	    echo ""
	    echo "詳細についてはインストールマニュアル P8 を参照して下さい。"
	    echo ""
	    rm -rf ${EXEC_PATH}/tmp.txt
	    exit 1
	else
	    rm -rf ${EXEC_PATH}/tmp.txt
	fi
	
	# インストールするパッケージの依存関係をチェックする
	for p_name in "${CHECK_RPMS[@]}"
	do
	    rpm -U --force --nosignature --test "${p_name}" >/dev/null 2>> ${EXEC_PATH}/tmp.txt
	done
	
	#結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
	    echo "NG"
	    echo "Hinemosエージェントをインストールするには以下のパッケージが不足しています。"
	    cat ${EXEC_PATH}/tmp.txt |grep -v : |awk '{print $1}'
	    echo ""
	    echo "詳細についてはインストールマニュアル P8 を参照して下さい。"
	    echo ""
	    rm -rf ${EXEC_PATH}/tmp.txt
	    exit 1
	else
	    echo "OK"
	    echo ""
	    rm -rf ${EXEC_PATH}/tmp.txt
	fi
	
	# 一括制御機能で使用しているコマンドのパッケージの有無をチェックする
	for p_name in ${CHECK_PACKAGE[@]}
	do
	    rpm_check ${p_name}
	    if [ ${check_flg} = 1 ]; then
	        echo ${p_name} >> ${EXEC_PATH}/tmp.txt
	    fi
	done
	
	#結果を表示
	if [ -s ${EXEC_PATH}/tmp.txt ]; then
	    echo ""
	    echo "警告：一括制御機能を全て使用するには以下のパッケージを別途インストールする必要があります。"
	    cat ${EXEC_PATH}/tmp.txt
	    echo ""
	    echo "詳細についてはインストールマニュアル P8 を参照して下さい。"
	    echo ""
	    sleep 2
	    rm -rf ${EXEC_PATH}/tmp.txt
	fi
	
	rm -rf ${EXEC_PATH}/tmp.txt
	
	##
	## パッケージのチェック END
	##
}


##
## インストーラ本編
##
while [ 1 ];
do
  echo "Hinemos エージェント の"
  echo "     1) インストール"
  echo "     2) アンインストール"
  echo "     9) インストーラの終了"
  echo ""
  echo -n "===> "
  
  read CHOSEN_NUMBER
  
  case ${CHOSEN_NUMBER} in
      1)      
	  
	  echo ""
	  echo "エージェントセットアップを行います。"
	  echo ""
	  echo ""

		while [ 1 ];
		  do
		  echo "インストールを開始します。よろしいですか?(Y/N)"
		  read ANS
		  case ${ANS} in
		      y|Y)
			  
			  # インストール準備部分
			  
			  # 確認
			  pre_install
			  
			  if [ ! -d ${HINEMOS_AGENT_HOME} ]; then
			      echo "${HINEMOS_AGENT_HOME}は存在しません。作成します。"
			      echo "mkdir -p ${HINEMOS_AGENT_HOME}" 
			      echo ""
			  fi

			  while [ ! "${IPADDR}" ] ;
			  do
			      echo -n "マネージャのIPアドレスを入力して下さい："
			      read IPADDR
			  done
			
			  # コピー開始
			  echo "必要なファイルのコピーを開始します。"
			  cp -pr $EXEC_PATH/hinemos_agent /opt
			  cp -p $EXEC_PATH/hinemos_agent.cfg ${HINEMOS_AGENT_HOME}/bin
			  echo "必要なファイルのコピーが終了しました。"
			  echo ""
			  echo "JREのインストールをおこないます。"
			  sleep 2
			  echo ""
			  cp ${EXEC_PATH}/jre-1_5_0_09-linux-i586.bin ${HINEMOS_AGENT_HOME}
			  CURRENT_DIR=`pwd`
			  cd ${HINEMOS_AGENT_HOME}
			  ${HINEMOS_AGENT_HOME}/jre-1_5_0_09-linux-i586.bin
			  rm ${HINEMOS_AGENT_HOME}/jre-1_5_0_09-linux-i586.bin
			  cd $CURRENT_DIR
			
			  # ジョブエージェントへのマネージャIPアドレスの反映
			  sed "s/%%manager%%/$IPADDR/" ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties > ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties_tmp
			  mv -f ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties_tmp ${HINEMOS_AGENT_HOME}/lib/agent/Agent.properties

			  # ログ転送エージェントへのマネージャIPアドレスの反映
                          sed "s/%%manager%%/$IPADDR/" ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties > ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties_tmp
                          mv -f ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties_tmp ${HINEMOS_AGENT_HOME}/lib/log_agent/Agent.properties

			  #ログへのホスト名の反映のための設定
			  sed "s/%%HOST%%/$HOST/" ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties > ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties_tmp
                          mv -f ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties_tmp  ${HINEMOS_AGENT_HOME}/lib/log_agent/log4j.properties
 
			  #一括制御機能のセットアップ
			  echo "一括制御機能のセットアップを行なっています。"
			  echo ""
			  while [ 1 ] ;
			  do
				  echo "一括制御機能の実行方式を入力して下さい。"
				  echo "     1) ssh"
				  echo "     2) rsh"
				  echo ""
				  echo -n "===> "
				  read SHELL

				  case ${SHELL} in
					1)
					  break
					  ;;
					2)
					  echo "rsh" >> /etc/securetty
					  echo "${IPADDR} hinemos" > ~/.rhosts
					  break
					  ;;
					*)
					  echo ""
					  ;;
				  esac
			  done
			  
		          #性能管理機能のセットアップ
			  echo "性能管理機能のセットアップを行なっています。"
			  echo "Net-SNMPのインストール"
			  rpm -Uvh --force --nosignature $SNMP_RPM
			  echo "view    systemview    included   .1.3.6.1 " >> /etc/snmp/snmpd.conf
			  echo "/etc/init.d/snmpd restart"
			  /etc/init.d/snmpd restart
			  echo "/sbin/chkconfig --level 345 snmpd on"
			  /sbin/chkconfig --level 345 snmpd on
			  
          		  #監視管理機能のセットアップ
			  echo "監視管理機能のセットアップを行なっています。"
			  echo ""
			  TMP_M=0
			  TMP_A=0
			  TMP_DNS=0
			  
			  grep "add for Hinemos Manager" /etc/syslog-ng/syslog-ng.conf > /dev/null 2>&1 && TMP_M=1
			  grep "add for Hinemos Agent" /etc/syslog-ng/syslog-ng.conf > /dev/null 2>&1 && TMP_A=1

			  if [ "${TMP_M}" -eq 0 ] ; then
				if [ "${TMP_A}" -eq 0 ] ; then
				  echo "syslog-ngのインストール"
				  rpm -Uvh --force $SYSLOG_NG_RPM
				  LOCAL_ADDR=`grep $HOST $HOSTS_FILE | grep -v ^\# | gawk '{print $1}'`
				  echo "#add for Hinemos Agent" >> /etc/syslog-ng/syslog-ng.conf
				  echo "filter f_hinemos_log { facility(user);  };" >> /etc/syslog-ng/syslog-ng.conf
				  echo "source s_netudp { udp(ip($LOCAL_ADDR) port(514)); };" >>/etc/syslog-ng/syslog-ng.conf
				  echo "log { source(s_netudp); filter(f_hinemos_log); destination(d_hinemos);};" >>/etc/syslog-ng/syslog-ng.conf
				  echo "destination d_hinemos { tcp(\"${IPADDR}\" port(514));};" >> /etc/syslog-ng/syslog-ng.conf
				  echo "log { source(s_local);filter(f_mesg);destination(d_hinemos);};" >> /etc/syslog-ng/syslog-ng.conf
				fi
			  fi
			  
			  # /etc/syslog-ng/syslog-ng.conf use_dns の編集
			  grep "use_dns" /etc/syslog-ng/syslog-ng.conf | grep "yes" > /dev/null 2>&1 && TMP_DNS=1
			  
			  if [ "${TMP_DNS}" -eq 0 ] ; then

				  SYSLOG_NG_TMP=`grep "use_dns" /etc/syslog-ng/syslog-ng.conf`
				  SYSLOG_NG_TMP_INSERT=`echo ${SYSLOG_NG_TMP} | sed "s/no/yes/g"`
				  
				  sed "s/${SYSLOG_NG_TMP}/#${SYSLOG_NG_TMP}\n\t${SYSLOG_NG_TMP_INSERT}/g" /etc/syslog-ng/syslog-ng.conf > /etc/syslog-ng/syslog-ng.conf_tmp
				  mv -f /etc/syslog-ng/syslog-ng.conf_tmp /etc/syslog-ng/syslog-ng.conf
				  
			  fi
			  
			  # syslogの停止・syslog-ngの起動
			  /etc/init.d/syslog stop
			  /etc/init.d/syslog-ng start
			  /sbin/chkconfig --level 2345 syslog off
			  /sbin/chkconfig --level 2345 syslog-ng on
			  
			  echo ""

		      break
		      ;;

		      n|N)
			  echo "インストールを中止してメニューに戻ります。"
			  echo ""
			  sleep 1
			  break
			  ;;
		      *)
		  esac
		done
                ;;
      2)      
	  echo "Hinemosエージェントをアンインストールします。よろしいですか?(Y/N)"
	  read ANS
	  case ${ANS} in
	      y|Y)
		TMP=0
		grep "add for Hinemos Manager" /etc/syslog-ng/syslog-ng.conf > /dev/null 2>&1 && TMP=1
		if [ !"${TMP}" ] ; then
			echo "Syslog-ngを停止します。"
			  /etc/init.d/syslog-ng stop
			  /etc/init.d/syslog start
		 	  /sbin/chkconfig --level 2345 syslog on
			  /sbin/chkconfig --level 2345 syslog-ng off
		fi

		echo "Net-SNMPを停止します。"
		 /etc/init.d/snmpd stop
		 /sbin/chkconfig --level 2345 snmpd off

		 TMP=0
		 tail -1 /etc/snmp/snmpd.conf | grep "view    systemview    included   .1.3.6.1 " > /dev/null 2>&1 && TMP=1
		 if [ ${TMP} ] ; then
			COUNT=`cat /etc/snmp/snmpd.conf | wc -l`
		 	COUNT=`expr ${COUNT} - 1`
			head -${COUNT} /etc/snmp/snmpd.conf >/etc/snmp/snmpd.conf_hinemos_back
			mv /etc/snmp/snmpd.conf_hinemos_back /etc/snmp/snmpd.conf
		 fi 
		
		grep "rsh" /etc/securetty > /dev/null 2>&1
		TMP=$?
		if [ ${TMP} -eq 0 ] ; then
			echo "/etc/securettyからrshを削除しますか?(Y/N)"
			read TTY
			case ${TTY} in
			y|Y)
				grep -v rsh /etc/securetty > /etc/securetty.tmp
				mv /etc/securetty.tmp /etc/securetty
			;;
			*)
			;;
			esac
		fi
		if [ -f /root/.rhosts ] ; then
                        echo "/root/.rhosts を削除しますか?(Y/N)"
                        read RHOSTS
                        case ${RHOSTS} in
                        y|Y)
                                rm /root/.rhosts
                        ;;
                        *)
                        ;;
                        esac
                fi

		 rm -fr ${HINEMOS_AGENT_HOME}
		;;
	      *)
		;;
	  esac
	  echo ""
	  ;;
      9)      
	  echo "Hinemosエージェント インストーラを終了します。"
	  exit
	  ;;
	*)
	  echo ""
	  sleep 1
	  ;;
  esac
done
