package jp.gr.java_conf.ykhr.csvutil.converter;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import jp.gr.java_conf.ykhr.csvutil.ReaderUtils;
import jp.gr.java_conf.ykhr.csvutil.Utils;
import jp.gr.java_conf.ykhr.csvutil.config.ReadConfig;
import jp.gr.java_conf.ykhr.csvutil.ex.CSVReadException;

public class HeaderBaseConverter implements Converter {
    
    public <T>Collection<T> toBeanCollection(Class<T> clazz, Collection<String[]> elements, ReadConfig config)
    throws CSVReadException {

        if (!config.isExistHeader()) {
            throw new CSVReadException();
        }
        
        Map<String, PropertyDescriptor> nameToProperty 
            = getNameToPropertyMapping(clazz);
        
        Collection<T> beans = new ArrayList<T>();
        Iterator<String[]> iter = elements.iterator();
        String[] header = iter.next();
        
        // validate
        checkNotSameHeader(header);
        checkHeaderProperty(nameToProperty, header);
        
        for ( ; iter.hasNext(); ) {
            String[] data = iter.next();
            T bean = ReaderUtils.createBeanInstance(clazz);
            
            for (int i = 0; i < data.length; i++) {
                PropertyDescriptor desc = nameToProperty.get(header[i]);
                Method method = desc.getWriteMethod();
                Class<?>[] types = method.getParameterTypes();
                if (types.length < 1) {
                    continue;
                }
                Object param = ReaderUtils.convertType(data[i], types[0]);
                if (param != null) {
                    ReaderUtils.setObject(bean, method, param);
                }
            }
            
            beans.add(bean);
        }
        
        return beans;
    }
    
    private void checkNotSameHeader(String[] header) throws CSVReadException {
        Set<String> set = new HashSet<String>();
        for (String str : header) {
            set.add(str);
        }
        if (set.size() != header.length) {
            throw new CSVReadException();
        }
    }
    
    private void checkHeaderProperty(Map<String, PropertyDescriptor> nameToProperty, String[] header) 
    throws CSVReadException {
        for (String str : header) {
            if (!nameToProperty.containsKey(str)) {
                throw new CSVReadException();
            }
        }
    }
    
    private <T> Map<String, PropertyDescriptor> getNameToPropertyMapping(Class<T> clazz) 
    throws CSVReadException {
        try {
            return Utils.createCsvNameToProperty(clazz);
        } catch (IntrospectionException e) {
            throw new CSVReadException(e);
        }
    }
    
}
