package jp.gr.java_conf.ykhr.csvutil.sample;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import jp.gr.java_conf.ykhr.csvutil.CSVWriter;
import jp.gr.java_conf.ykhr.csvutil.ex.CSVWriteException;

public class WriteSample1 {
    
    public static void main(String[] args) {
        List<SampleBean> list = new ArrayList<SampleBean>();
        SampleBean bean1 = new SampleBean();
        bean1.setName("ykhr");
        bean1.setAge(26);
        bean1.setNickName("ykhr-kokko");
        list.add(bean1);
        
        SampleBean bean2 = new SampleBean();
        bean2.setName("kokko");
        bean2.setAge(23);
        bean2.setNickName("xxxxx");
        list.add(bean2);

        SampleBean bean3 = new SampleBean();
        bean3.setName("hoge\"-\"foo");
        bean3.setAge(99);
        bean3.setNickName("hoge\r\nfoo");
        bean3.setTekitouField("tekitou");
        list.add(bean3);
        
        SampleBean bean4 = new SampleBean();
        bean4.setName("null-man");
        bean4.setNickName(null);
        bean4.setAge(40);
        list.add(bean4);
        
        CSVWriter writer = new CSVWriter();
        try {
            writer.write(new File("sample/sample_write1.csv"), list, SampleBean.class);
        } catch (CSVWriteException e) {
            e.printStackTrace();
        }
    }

}
