package jp.gr.java_conf.ykhr.csvutil.sample;

import java.io.File;
import java.util.Collection;

import jp.gr.java_conf.ykhr.csvutil.CSVReader;
import jp.gr.java_conf.ykhr.csvutil.config.ReadConfig;
import jp.gr.java_conf.ykhr.csvutil.converter.PriorityConverter;
import jp.gr.java_conf.ykhr.csvutil.ex.CSVReadException;

public class ReadSample2 {
    
    public static void main(String[] args) {
        CSVReader reader = new CSVReader(new PriorityConverter());
        ReadConfig config = new ReadConfig();
        config.setExistHeader(false);
        try {
            Collection<SampleBean> list = reader.read(new File("sample/sample_read2.csv"), SampleBean.class, config);
            for (SampleBean bean : list) {
                System.out.println(bean);
            }
        } catch (CSVReadException e) {
            e.printStackTrace();
        }
    }

}
